/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.util;

import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

@NotThreadSafe
public class TransactionBatcher {
    private final PlatformTransactionManager transactionManager;
    private final int batchSize;
    private final String identifier;
    private TransactionStatus tx;
    private int committedCount;
    private int count;

    public TransactionBatcher(PlatformTransactionManager transactionManager, int batchSize, String identifier) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("Batch size must be positive");
        }
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager");
        this.batchSize = batchSize;
        this.identifier = Objects.requireNonNull(identifier, "identifier");
    }

    public void commit() {
        TransactionStatus tx = this.tx;
        if (tx != null && !tx.isCompleted()) {
            this.tx = null;
            this.transactionManager.commit(tx);
            this.committedCount = this.count;
        }
    }

    public int getCount() {
        return this.count;
    }

    public int getUncommittedCount() {
        return this.count - this.committedCount;
    }

    public boolean rollback() {
        TransactionStatus tx = this.tx;
        if (tx != null && !tx.isCompleted()) {
            this.tx = null;
            this.transactionManager.rollback(tx);
            return true;
        }
        return false;
    }

    public void start() {
        if (this.tx != null && !this.tx.isCompleted()) {
            throw new IllegalStateException("Batch transaction must be committed before a new one can be started");
        }
        DefaultTransactionAttribute def = new DefaultTransactionAttribute();
        def.setName("TransactionBatch:" + this.identifier + ":" + this.count);
        def.setPropagationBehavior(3);
        this.tx = this.transactionManager.getTransaction((TransactionDefinition)def);
    }

    public boolean tick() {
        boolean ticked;
        if (this.tx == null || this.tx.isCompleted()) {
            throw new IllegalStateException("Batch transaction must be started before the first element is processed");
        }
        boolean bl = ticked = ++this.count % this.batchSize == 0;
        if (ticked) {
            this.commit();
            this.start();
        }
        return ticked;
    }
}

