/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.watcher;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.watch.WatcherAddedEvent;
import com.atlassian.bitbucket.event.watch.WatcherRemovedEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.watcher.AbstractWatcherRequest;
import com.atlassian.bitbucket.watcher.IsWatchingRequest;
import com.atlassian.bitbucket.watcher.UnwatchRequest;
import com.atlassian.bitbucket.watcher.WatchRequest;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.bitbucket.watcher.WatcherSearchRequest;
import com.atlassian.bitbucket.watcher.WatcherService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherMapping;
import com.atlassian.stash.internal.watcher.SimpleWatcher;
import com.atlassian.stash.internal.watcher.WatcherMappingDao;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=WatcherService.class)
@Service(value="watcherService")
public class DefaultWatcherService
extends AbstractService
implements WatcherService {
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final WatcherMappingDao watcherMappingDao;

    @Autowired
    public DefaultWatcherService(AuthenticationContext authenticationContext, EventPublisher eventPublisher, WatcherMappingDao watcherMappingDao) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.watcherMappingDao = watcherMappingDao;
    }

    @PreAuthorize(value="#request.user != null or isAuthenticated()")
    public boolean isWatching(@Nonnull IsWatchingRequest request) {
        Objects.requireNonNull(request, "request");
        return this.isWatching(this.getUserOrDefault((AbstractWatcherRequest)request), InternalConverter.convertToInternalWatchable((Watchable)request.getWatchable()));
    }

    @Nonnull
    public Page<Watcher> search(@Nonnull WatcherSearchRequest request, @Nonnull PageRequest pageRequest) {
        InternalWatchable watchable = InternalConverter.convertToInternalWatchable((Watchable)Objects.requireNonNull(request, "request").getWatchable());
        return this.watcherMappingDao.findByWatchable(watchable, request.isTransitive(), pageRequest).transform(mapping -> 3 == mapping.getWatchableType() ? new SimpleWatcher((Watchable)watchable.getScopeRepository(), (ApplicationUser)mapping.getUser()) : new SimpleWatcher((Watchable)watchable, (ApplicationUser)mapping.getUser()));
    }

    @PreAuthorize(value="#request.user != null or isAuthenticated()")
    @Transactional
    public boolean unwatch(@Nonnull UnwatchRequest request) {
        Objects.requireNonNull(request, "request");
        InternalApplicationUser user = this.getUserOrDefault((AbstractWatcherRequest)request);
        InternalWatchable watchable = InternalConverter.convertToInternalWatchable((Watchable)request.getWatchable());
        return this.watcherMappingDao.findByWatchableAndUser(watchable, user).map(mapping -> {
            this.watcherMappingDao.delete(mapping);
            this.eventPublisher.publish((Object)new WatcherRemovedEvent((Object)this, (Watcher)new SimpleWatcher((Watchable)watchable, (ApplicationUser)user)));
            return true;
        }).orElse(false);
    }

    @Nonnull
    @PreAuthorize(value="#request.user != null or isAuthenticated()")
    @Transactional
    public Watcher watch(@Nonnull WatchRequest request) {
        Objects.requireNonNull(request, "request");
        InternalApplicationUser user = this.getUserOrDefault((AbstractWatcherRequest)request);
        InternalWatchable watchable = InternalConverter.convertToInternalWatchable((Watchable)request.getWatchable());
        SimpleWatcher watcher = new SimpleWatcher((Watchable)watchable, (ApplicationUser)user);
        if (!this.isWatching(user, watchable)) {
            this.watcherMappingDao.create((Object)new InternalWatcherMapping.Builder(watchable, user).build());
            this.eventPublisher.publish((Object)new WatcherAddedEvent((Object)this, (Watcher)watcher));
        }
        return watcher;
    }

    private InternalApplicationUser getUserOrDefault(AbstractWatcherRequest request) {
        return InternalConverter.convertToInternalUser((ApplicationUser)request.getUser().orElseGet(() -> ((AuthenticationContext)this.authenticationContext).getCurrentUser()));
    }

    private boolean isWatching(InternalApplicationUser user, InternalWatchable watchable) {
        return this.watcherMappingDao.findByWatchableAndUser(watchable, user).isPresent();
    }
}

