/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.zdu;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.features.RequireFeature;
import com.atlassian.bitbucket.dmz.zdu.DmzRollingUpgradeService;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.bitbucket.zdu.IllegalRollingUpgradeStateException;
import com.atlassian.bitbucket.zdu.RollingUpgradeService;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.BuildInfo;
import com.atlassian.stash.internal.zdu.RollingUpgradeState;
import com.atlassian.stash.internal.zdu.RollingUpgradeStateManager;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(interfaces={RollingUpgradeService.class, DmzRollingUpgradeService.class})
@RequireFeature(value=StandardFeature.ROLLING_UPGRADE)
@Service(value="rollingUpgradeService")
public class DefaultRollingUpgradeService
implements DmzRollingUpgradeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRollingUpgradeService.class);
    private final ApplicationModeSupplier applicationModeSupplier;
    private final BuildInfo buildInfo;
    private final ClusterService clusterService;
    private final I18nService i18nService;
    private final RollingUpgradeStateManager rollingUpgradeStateManager;
    private final SecurityService securityService;

    @Autowired
    public DefaultRollingUpgradeService(BuildInfo buildInfo, ClusterService clusterService, I18nService i18nService, RollingUpgradeStateManager rollingUpgradeStateManager, SecurityService securityService, ApplicationModeSupplier applicationModeSupplier) {
        this.applicationModeSupplier = applicationModeSupplier;
        this.buildInfo = buildInfo;
        this.clusterService = clusterService;
        this.i18nService = i18nService;
        this.rollingUpgradeStateManager = rollingUpgradeStateManager;
        this.securityService = securityService;
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void disableUpgradeMode() {
        if (!this.isUpgradeModeEnabled()) {
            log.debug("Ignoring request to disable upgrade mode as it is already disabled");
            return;
        }
        if (!this.isClusterStable()) {
            throw new IllegalRollingUpgradeStateException(this.i18nService.createKeyedMessage("bitbucket.service.zdu.invalid.upgrade.mode.disable", new Object[0]));
        }
        this.rollingUpgradeStateManager.setRollingUpgradeState(new RollingUpgradeState(false, null));
        log.info("Disabled upgrade mode; cluster currently on stable version {}", (Object)new Version(this.buildInfo.getBuildVersion()));
        this.reconcileUpgradeMode();
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void enableUpgradeMode() {
        if (this.isUpgradeModeEnabled()) {
            log.debug("Ignoring request to enable upgrade mode as it is already enabled");
            return;
        }
        Version minVersion = this.streamNodeVersions().min(Version::compareTo).orElse(new Version(this.buildInfo.getBuildVersion()));
        this.rollingUpgradeStateManager.setRollingUpgradeState(new RollingUpgradeState(true, minVersion));
        log.info("Enabled upgrade mode; cluster currently on stable version {}", (Object)minVersion);
    }

    @Nonnull
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public Optional<Version> getOriginalVersion() {
        return this.rollingUpgradeStateManager.getRollingUpgradeState().getOriginalVersion();
    }

    public boolean isClusterStable() {
        return this.streamNodeVersions().distinct().count() == 1L;
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional(readOnly=true)
    public boolean isUpgradeModeEnabled() {
        return this.rollingUpgradeStateManager.getRollingUpgradeState().isUpgradeModeEnabled();
    }

    @EventListener
    public void onClusterNodeAdded(ClusterNodeAddedEvent ignored) {
        if (this.applicationModeSupplier.getMode() == ApplicationMode.MIRROR) {
            return;
        }
        this.reconcileUpgradeMode();
    }

    private void reconcileUpgradeMode() {
        if (this.isClusterStable()) {
            return;
        }
        log.warn("Cluster contains nodes with different versions; enabling upgrade mode to reconcile cluster state. You may have unexpected cluster state");
        this.securityService.withPermission(Permission.SYS_ADMIN, "Enabling upgrade mode to reconcile cluster state").call(() -> {
            this.enableUpgradeMode();
            return null;
        });
    }

    private Stream<Version> streamNodeVersions() {
        return this.clusterService.getInformation().getNodes().stream().map(ClusterNode::getBuildVersion);
    }
}

