/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.zdu;

import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.zdu.RollingUpgradeState;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RollingUpgradeStateManager {
    private final ApplicationPropertyDao applicationPropertyDao;

    @Autowired
    public RollingUpgradeStateManager(ApplicationPropertyDao applicationPropertyDao) {
        this.applicationPropertyDao = applicationPropertyDao;
    }

    @Nonnull
    public RollingUpgradeState getRollingUpgradeState() {
        String originalVersion = this.getApplicationProperty(ApplicationProperty.Key.ROLLING_UPGRADE_ORIGINAL_VERSION);
        return originalVersion == null ? new RollingUpgradeState(false, null) : new RollingUpgradeState(Boolean.parseBoolean(this.getApplicationProperty(ApplicationProperty.Key.ROLLING_UPGRADE_ENABLED)), new Version(originalVersion));
    }

    public void setRollingUpgradeState(@Nonnull RollingUpgradeState rollingUpgradeState) {
        Objects.requireNonNull(rollingUpgradeState, "rollingUpgradeState");
        this.upsertApplicationProperty(ApplicationProperty.Key.ROLLING_UPGRADE_ENABLED, Boolean.toString(rollingUpgradeState.isUpgradeModeEnabled()));
        if (rollingUpgradeState.isUpgradeModeEnabled()) {
            this.upsertApplicationProperty(ApplicationProperty.Key.ROLLING_UPGRADE_ORIGINAL_VERSION, Objects.requireNonNull((String)rollingUpgradeState.getOriginalVersion().map(Version::toString).orElse(null), "originalVersion is required when upgrade mode is enabled"));
        } else {
            this.applicationPropertyDao.deleteById(ApplicationProperty.Key.ROLLING_UPGRADE_ORIGINAL_VERSION);
        }
    }

    private String getApplicationProperty(ApplicationProperty.Key key) {
        ApplicationProperty applicationProperty = this.applicationPropertyDao.getById(key);
        return applicationProperty == null ? null : applicationProperty.getValue();
    }

    private void upsertApplicationProperty(ApplicationProperty.Key key, String value) {
        String oldValue = this.getApplicationProperty(key);
        ApplicationProperty newProperty = new ApplicationProperty(key, value);
        if (oldValue == null) {
            this.applicationPropertyDao.create(newProperty);
        } else {
            this.applicationPropertyDao.update(newProperty);
        }
    }
}

