/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.minimumbuilds;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragment;
import com.atlassian.bitbucket.rest.v2.fragment.RestFragmentContext;
import com.atlassian.stash.internal.build.minimumbuilds.MinimumBuildsHelper;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Optional;

public class LegacyMinimumBuildsRestFragment
implements RestFragment {
    private static final String REQUIRED_BUILDS_KEY = "requiredSuccessfulBuilds";
    private final MinimumBuildsHelper helper;
    private final I18nService i18nService;

    public LegacyMinimumBuildsRestFragment(MinimumBuildsHelper helper, I18nService i18nService) {
        this.helper = helper;
        this.i18nService = i18nService;
    }

    @Nonnull
    public Map<String, Object> execute(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        Repository repository = (Repository)requestContext.get("repository");
        if (fragmentContext.getMethod().equals("GET")) {
            return this.doGet(repository);
        }
        if (fragmentContext.getMethod().equals("POST")) {
            return this.doPost(fragmentContext, repository);
        }
        return ImmutableMap.of((Object)REQUIRED_BUILDS_KEY, (Object)this.i18nService.getMessage("bitbucket.build.required.rest.method.unsupported", new Object[]{fragmentContext.getMethod()}));
    }

    @Nonnull
    public Map<String, Object> validate(@Nonnull RestFragmentContext fragmentContext, @Nonnull Map<String, Object> requestContext) {
        Optional property;
        if (fragmentContext.getMethod().equals("POST") && (property = fragmentContext.getBodyProperty(REQUIRED_BUILDS_KEY)).isPresent()) {
            if (property.get() instanceof Number) {
                int buildCount = ((Number)property.get()).intValue();
                if (buildCount < 0) {
                    return new RestErrorMessage(REQUIRED_BUILDS_KEY, this.i18nService.getMessage("bitbucket.build.required.count.negativenumber", new Object[0]));
                }
            } else {
                return new RestErrorMessage(REQUIRED_BUILDS_KEY, this.i18nService.getMessage("bitbucket.build.required.count.notanumber", new Object[0]));
            }
        }
        return ImmutableMap.of();
    }

    private Map<String, Object> doGet(Repository repository) {
        return ImmutableMap.of((Object)REQUIRED_BUILDS_KEY, (Object)this.helper.getCountDeprecated(repository));
    }

    private Map<String, Object> doPost(RestFragmentContext fragmentContext, Repository repository) {
        fragmentContext.getBodyProperty("com.atlassian.bitbucket.server.bitbucket-build:requiredBuilds").orElseGet(() -> {
            fragmentContext.getBodyProperty(REQUIRED_BUILDS_KEY).ifPresent(n -> this.helper.saveCount(repository, ((Number)n).intValue()));
            return null;
        });
        return this.doGet(repository);
    }
}

