/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.minimumbuilds;

import com.atlassian.bitbucket.dmz.build.status.BuildSummary;
import com.atlassian.bitbucket.dmz.build.status.DmzBuildStatusService;
import com.atlassian.bitbucket.dmz.build.status.PullRequestBulkCommitBuildStatusSummaryRequest;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.annotation.Nonnull;

public class MinimumBuildsMergeCheck
implements RepositoryMergeCheck {
    private final DmzBuildStatusService buildStatusService;
    private final I18nService i18nService;
    private final SecurityService securityService;
    private final BuildSummary emptyBuildSummary;

    public MinimumBuildsMergeCheck(DmzBuildStatusService buildStatusService, I18nService i18nService, SecurityService securityService) {
        this.buildStatusService = buildStatusService;
        this.i18nService = i18nService;
        this.securityService = securityService;
        this.emptyBuildSummary = new BuildSummary(this){

            public int getCancelledCount() {
                return 0;
            }

            public int getSuccessfulCount() {
                return 0;
            }

            public int getFailedCount() {
                return 0;
            }

            public int getInProgressCount() {
                return 0;
            }

            public int getUnknownCount() {
                return 0;
            }
        };
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        PullRequest pullRequest = request.getPullRequest();
        int requiredCount = context.getSettings().getInt("requiredCount", 0);
        if (requiredCount <= 0) {
            return RepositoryHookResult.accepted();
        }
        BuildSummary stats = this.getBuildStats(pullRequest);
        int failedCount = stats.getFailedCount();
        int inProgressCount = stats.getInProgressCount();
        int successfulCount = stats.getSuccessfulCount();
        int cancelledCount = stats.getCancelledCount();
        int unknownCount = stats.getUnknownCount();
        Object vetoMessage = null;
        if (failedCount > 0) {
            vetoMessage = this.i18nService.getMessage("bitbucket.build.required.count.veto.failed.message", new Object[0]);
        } else if (inProgressCount > 0) {
            vetoMessage = this.i18nService.getMessage("bitbucket.build.required.count.veto.inprogress.message", new Object[0]);
        } else if (cancelledCount > 0) {
            vetoMessage = this.i18nService.getMessage("bitbucket.build.required.count.veto.cancelled.message", new Object[0]);
        } else if (unknownCount > 0) {
            vetoMessage = this.i18nService.getMessage("bitbucket.build.required.count.veto.unknown.message", new Object[0]);
        }
        int totalBuildCount = successfulCount + failedCount + inProgressCount + cancelledCount + unknownCount;
        if (totalBuildCount < requiredCount) {
            String neededMessage = this.i18nService.getMessage("bitbucket.build.required.count.veto.message", new Object[]{requiredCount});
            vetoMessage = vetoMessage == null ? neededMessage : (String)vetoMessage + " " + neededMessage;
        }
        if (vetoMessage != null) {
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.build.required.count.veto.short.message", new Object[0]), (String)vetoMessage);
        }
        return RepositoryHookResult.accepted();
    }

    private BuildSummary getBuildStats(PullRequest pullRequest) {
        return (BuildSummary)this.securityService.withPermission(Permission.REPO_READ, "Getting build status summary").call(() -> this.buildStatusService.getSummaries(new PullRequestBulkCommitBuildStatusSummaryRequest.Builder(pullRequest, new String[0]).build()).values().stream().findAny().orElse(this.emptyBuildSummary));
    }
}

