/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.hook;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.BuildStatusPullRequestSearchRequest;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusService;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.build.requiredbuilds.RequiredBuildsService;
import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.stream.Collectors;

public class RequiredBuildMergeCheck
implements RepositoryMergeCheck {
    private static final int BUILD_STATUS_PAGE_SIZE = 100;
    private final RepositoryBuildStatusService buildStatusService;
    private final I18nService i18nService;
    private final RequiredBuildsService mergeCheckService;

    public RequiredBuildMergeCheck(RepositoryBuildStatusService buildStatusService, RequiredBuildsService mergeCheckService, I18nService i18nService) {
        this.buildStatusService = buildStatusService;
        this.mergeCheckService = mergeCheckService;
        this.i18nService = i18nService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        PullRequest pullRequest = request.getPullRequest();
        BuildStatusPullRequestSearchRequest searchRequest = ((BuildStatusPullRequestSearchRequest.Builder)new BuildStatusPullRequestSearchRequest.Builder(pullRequest).commitId(pullRequest.getFromRef().getLatestCommit())).build();
        Set successfulBuildStatusParents = PageUtils.toStream(pageRequest -> this.buildStatusService.search(searchRequest, pageRequest), (int)100).filter(buildStatus -> BuildState.SUCCESSFUL == buildStatus.getState()).filter(buildStatus -> buildStatus.getParent().isPresent()).map(buildStatus -> (String)buildStatus.getParent().get()).collect(Collectors.toSet());
        Set requiredPassingParentKeys = this.mergeCheckService.getConditionsFor(pullRequest).stream().flatMap(mergeCheck -> mergeCheck.getBuildParentKeys().stream()).collect(Collectors.toSet());
        requiredPassingParentKeys.removeAll(successfulBuildStatusParents);
        if (!requiredPassingParentKeys.isEmpty()) {
            return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.build.requiredbuilds.hook.veto.short.message", new Object[0]), (String)this.i18nService.getMessage("bitbucket.build.requiredbuilds.hook.veto.message", new Object[]{requiredPassingParentKeys.stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.joining(", ")), requiredPassingParentKeys.size()}));
        }
        return RepositoryHookResult.accepted();
    }
}

