/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.model;

import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.stash.internal.build.requiredbuilds.model.RequiredBuildCondition;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SimpleRequiredBuildCondition
implements RequiredBuildCondition {
    private final Set<String> buildParentKeys;
    private final RefMatcher exemptRefMatcher;
    private final long id;
    private final RefMatcher refMatcher;
    private final Scope scope;

    private SimpleRequiredBuildCondition(Builder builder) {
        this.id = builder.id;
        this.buildParentKeys = builder.buildParentKeys;
        this.refMatcher = builder.refMatcher;
        this.exemptRefMatcher = builder.exemptRefMatcher;
        this.scope = builder.scope;
    }

    @Override
    @Nonnull
    public Set<String> getBuildParentKeys() {
        return this.buildParentKeys;
    }

    @Override
    @Nonnull
    public Optional<RefMatcher> getExemptRefMatcher() {
        return Optional.ofNullable(this.exemptRefMatcher);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public RefMatcher getRefMatcher() {
        return this.refMatcher;
    }

    @Override
    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    public static class Builder {
        private final Set<String> buildParentKeys;
        private final long id;
        private final RefMatcher refMatcher;
        private final Scope scope;
        private RefMatcher exemptRefMatcher;

        public Builder(long id, @Nonnull Set<String> buildParentKeys, @Nonnull RefMatcher refMatcher, @Nonnull Scope scope) {
            this.id = id;
            this.buildParentKeys = Objects.requireNonNull(buildParentKeys, "buildParentKeys");
            this.refMatcher = Objects.requireNonNull(refMatcher, "refMatcher");
            this.scope = Objects.requireNonNull(scope, "scope");
        }

        @Nonnull
        public SimpleRequiredBuildCondition build() {
            return new SimpleRequiredBuildCondition(this);
        }

        @Nonnull
        public Builder exemptRefMatcher(@Nonnull RefMatcher exemptRefMatcher) {
            this.exemptRefMatcher = Objects.requireNonNull(exemptRefMatcher, "exemptRefMatcher");
            return this;
        }
    }
}

