/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.pull;

import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.BuildStatusRepositorySearchRequest;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusService;
import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheck;
import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheckRequest;
import com.atlassian.bitbucket.dmz.pull.PreAcceptMergeCheckResult;
import com.atlassian.bitbucket.dmz.pull.SimplePreAcceptMergeCheckResult;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.build.requiredbuilds.RequiredBuildsService;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RequiredBuildPreAcceptMergeCheck
implements PreAcceptMergeCheck {
    private static final int PAGE_SIZE = 100;
    private final RepositoryBuildStatusService buildStatusService;
    private final I18nService i18nService;
    private final RequiredBuildsService requiredBuildsService;

    public RequiredBuildPreAcceptMergeCheck(RepositoryBuildStatusService buildStatusService, I18nService i18nService, RequiredBuildsService requiredBuildsService) {
        this.buildStatusService = buildStatusService;
        this.i18nService = i18nService;
        this.requiredBuildsService = requiredBuildsService;
    }

    @Nonnull
    public PreAcceptMergeCheckResult run(@Nonnull PreAcceptMergeCheckRequest request) {
        Objects.requireNonNull(request, "request");
        PullRequest pullRequest = request.getPullRequest();
        Set<String> requiredParents = this.getRequiredParents(pullRequest);
        if (requiredParents.isEmpty()) {
            return new SimplePreAcceptMergeCheckResult(PreAcceptMergeCheckResult.State.ACCEPTED, this.i18nService.getMessage("bitbucket.build.requiredbuilds.preacceptmergecheck.nobuilds", new Object[0]));
        }
        Branch branch = request.getPreparedPullRequestMerge().getBranch();
        BuildStatusRepositorySearchRequest searchRequest = ((BuildStatusRepositorySearchRequest.Builder)new BuildStatusRepositorySearchRequest.Builder(pullRequest.getToRef().getRepository()).ref((Ref)branch).commitId(branch.getLatestCommit())).build();
        List<RepositoryBuildStatus> requiredBuildStatuses = this.fetchRequiredBuildStatuses(searchRequest, requiredParents);
        Set<String> failedRequiredParents = this.getParentBuilds(requiredBuildStatuses, BuildState.CANCELLED, BuildState.FAILED, BuildState.UNKNOWN);
        if (!failedRequiredParents.isEmpty()) {
            return new SimplePreAcceptMergeCheckResult(PreAcceptMergeCheckResult.State.REJECTED, this.i18nService.getMessage("bitbucket.build.requiredbuilds.preacceptmergecheck.failed", new Object[]{failedRequiredParents}));
        }
        Set<String> successfulRequiredParents = this.getParentBuilds(requiredBuildStatuses, BuildState.SUCCESSFUL);
        Sets.SetView pendingRequiredParents = Sets.difference(requiredParents, successfulRequiredParents);
        if (pendingRequiredParents.isEmpty()) {
            return new SimplePreAcceptMergeCheckResult(PreAcceptMergeCheckResult.State.ACCEPTED, this.i18nService.getMessage("bitbucket.build.requiredbuilds.preacceptmergecheck.allsuccessful", new Object[]{successfulRequiredParents}));
        }
        return new SimplePreAcceptMergeCheckResult(PreAcceptMergeCheckResult.State.PENDING, this.i18nService.getMessage("bitbucket.build.requiredbuilds.preacceptmergecheck.pending", new Object[]{pendingRequiredParents}));
    }

    private List<RepositoryBuildStatus> fetchRequiredBuildStatuses(BuildStatusRepositorySearchRequest searchRequest, Set<String> requiredBuilds) {
        return PageUtils.toStream(pageRequest -> this.buildStatusService.search(searchRequest, pageRequest), (int)100).filter(buildStatus -> buildStatus.getParent().map(requiredBuilds::contains).orElse(false)).toList();
    }

    private Set<String> getParentBuilds(List<RepositoryBuildStatus> buildStatuses, BuildState ... states) {
        Set<BuildState> stateSet = Set.of(states);
        ImmutableSet.Builder parentBuilds = ImmutableSet.builder();
        for (RepositoryBuildStatus buildStatus : buildStatuses) {
            if (!stateSet.contains(buildStatus.getState())) continue;
            buildStatus.getParent().ifPresent(arg_0 -> ((ImmutableSet.Builder)parentBuilds).add(arg_0));
        }
        return parentBuilds.build();
    }

    private Set<String> getRequiredParents(PullRequest pullRequest) {
        return this.requiredBuildsService.getConditionsFor(pullRequest).stream().flatMap(requiredBuildCondition -> requiredBuildCondition.getBuildParentKeys().stream()).filter(StringUtils::isNotBlank).collect(Collectors.toUnmodifiableSet());
    }
}

