/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.requiredbuilds.rest;

import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.stash.internal.build.requiredbuilds.model.RequiredBuildCondition;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;

public class RestRequiredBuildCondition
extends RestMapEntity {
    private static final String BUILD_PARENT_KEYS = "buildParentKeys";
    private static final String EXEMPT_REF_MATCHER = "exemptRefMatcher";
    private static final String ID = "id";
    private static final String REF_MATCHER = "refMatcher";

    public RestRequiredBuildCondition() {
    }

    private RestRequiredBuildCondition(Map<String, Object> values) {
        super(values);
    }

    private RestRequiredBuildCondition(long id, List<String> buildParentKeys, RestRefMatcher refMatcher, RestRefMatcher exemptRefMatcher) {
        this.put(ID, id);
        this.put(BUILD_PARENT_KEYS, buildParentKeys);
        this.put(REF_MATCHER, refMatcher);
        this.putIfNotNull(EXEMPT_REF_MATCHER, exemptRefMatcher);
    }

    public RestRequiredBuildCondition(RequiredBuildCondition mergeCheck) {
        this.put(ID, mergeCheck.getId());
        this.put(BUILD_PARENT_KEYS, mergeCheck.getBuildParentKeys());
        this.put(REF_MATCHER, new RestRefMatcher(mergeCheck.getRefMatcher()));
        mergeCheck.getExemptRefMatcher().ifPresent(exemptRefMatcher -> this.put(EXEMPT_REF_MATCHER, new RestRefMatcher(exemptRefMatcher)));
    }

    @Nonnull
    @ArraySchema(arraySchema=@Schema(description="A non-empty list of build parent keys that require green builds for this merge check to pass", example="[\"build-key-1\", \"build-key-2\"]"))
    public List<String> getBuildParentKeys() {
        Object buildParentKeys = this.get(BUILD_PARENT_KEYS);
        if (buildParentKeys instanceof List && !((List)buildParentKeys).isEmpty()) {
            return (List)buildParentKeys;
        }
        return null;
    }

    @Nullable
    public RestRefMatcher getExemptRefMatcher() {
        return RestRefMatcher.valueOf((Object)this.get(EXEMPT_REF_MATCHER));
    }

    @Nonnull
    @Schema(example="15")
    public Long getID() {
        return this.getLongProperty(ID);
    }

    @Nonnull
    public RestRefMatcher getRefMatcher() {
        return RestRefMatcher.valueOf((Object)this.get(REF_MATCHER));
    }
}

