/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.status.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.build.BuildOrder;
import com.atlassian.bitbucket.build.BuildState;
import com.atlassian.bitbucket.build.status.RepositoryBuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.dao.DmzLegacyBuildDao;
import com.atlassian.bitbucket.dmz.build.status.legacy.BuildStatusSetRequest;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.dmz.build.status.legacy.SimpleLegacyBuildStatus;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.build.status.dao.AoBuildStatus;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="buildStatusAoDao")
public class AoBuildStatusDao
extends AbstractAoDao
implements DmzLegacyBuildDao {
    private static final Logger log = LoggerFactory.getLogger(AoBuildStatusDao.class);

    public AoBuildStatusDao(ActiveObjects ao) {
        super(ao);
    }

    private static Map<String, Object> toMap(BuildStatusSetRequest request, Date added) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder().put((Object)"CSID", (Object)request.getCommitId()).put((Object)"STATE", (Object)request.getState()).put((Object)"KEY", (Object)request.getKey()).put((Object)"URL", (Object)request.getUrl()).put((Object)"DATE_ADDED", (Object)added);
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            builder.put((Object)"NAME", (Object)request.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDescription())) {
            builder.put((Object)"DESCRIPTION", (Object)StringUtils.abbreviate((String)request.getDescription(), (int)255));
        }
        return builder.build();
    }

    private static Map<String, Object> toMap(RepositoryBuildStatusSetRequest request) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder().put((Object)"CSID", (Object)request.getCommitId()).put((Object)"STATE", (Object)request.getState()).put((Object)"KEY", (Object)request.getKey()).put((Object)"URL", (Object)request.getUrl()).put((Object)"DATE_ADDED", (Object)request.getLastUpdated());
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            builder.put((Object)"NAME", (Object)request.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDescription())) {
            builder.put((Object)"DESCRIPTION", (Object)StringUtils.abbreviate((String)request.getDescription(), (int)255));
        }
        return builder.build();
    }

    @Nonnull
    public Map<BuildState, Integer> countByState(@Nonnull String commitId) {
        EnumMap<BuildState, Integer> stats = new EnumMap<BuildState, Integer>(BuildState.class);
        this.ao.stream(AoBuildStatus.class, Query.select((String)"ID,STATE").where("CSID = ?", new Object[]{commitId}), status -> {
            BuildState state;
            Integer c = (Integer)stats.get(state = status.getState());
            stats.put(state, c == null ? 1 : c + 1);
        });
        return stats;
    }

    @Nonnull
    public Map<String, Map<BuildState, Integer>> countByState(@Nonnull Collection<String> commitIds) {
        if (commitIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap all = Maps.newHashMap();
        this.ao.stream(AoBuildStatus.class, AoUtils.newQuery((String[])new String[]{"ID", "CSID", "STATE"}).where("CSID in (" + StringUtils.repeat((String)"?", (String)",", (int)commitIds.size()) + ")", commitIds.toArray()), status -> {
            Integer c;
            String commitId = status.getCommitId();
            BuildState state = status.getState();
            Map stats = (Map)all.get(commitId);
            if (stats == null) {
                stats = Maps.newEnumMap(BuildState.class);
                all.put(commitId, stats);
            }
            stats.put(state, (c = (Integer)stats.get(state)) == null ? 1 : c + 1);
        });
        return all;
    }

    public int delete(String commitId, String key) {
        int deleted = this.ao.deleteWithSQL(AoBuildStatus.class, "CSID = ? AND KEY = ?", new Object[]{commitId, key});
        if (deleted > 1) {
            log.warn("{} build statuses for commitId \"{}\" and key \"{}\"", new Object[]{deleted, commitId, key});
        }
        return deleted;
    }

    @Nonnull
    public Page<LegacyBuildStatus> findAll(@Nonnull String commitId, @Nonnull PageRequest pageRequest, @Nonnull BuildOrder orderBy) {
        return this.pageQuery(AoBuildStatus.class, AoUtils.newQuery((String[])new String[]{"ID", "STATE", "KEY", "NAME", "URL", "DESCRIPTION", "DATE_ADDED"}).where("CSID = ?", new Object[]{commitId}).order(this.transformOrderToQuery(orderBy)), pageRequest).transform(AoBuildStatusDao::getLegacyBuildStatus);
    }

    @Nonnull
    public Optional<LegacyBuildStatus> get(@Nonnull String commitId, @Nonnull String key) {
        return this.pageQuery(AoBuildStatus.class, AoUtils.newQuery((String[])new String[]{"ID", "STATE", "KEY", "NAME", "URL", "DESCRIPTION", "DATE_ADDED"}).where("CSID = ? AND KEY = ?", new Object[]{commitId, key}).order(this.transformOrderToQuery(BuildOrder.NEWEST)), PageUtils.newRequest((int)0, (int)1)).transform(AoBuildStatusDao::getLegacyBuildStatus).stream().findFirst();
    }

    public LegacyBuildStatus set(BuildStatusSetRequest request, Date now) {
        int deleted = this.ao.deleteWithSQL(AoBuildStatus.class, "CSID = ? AND KEY = ?", new Object[]{request.getCommitId(), request.getKey()});
        if (deleted > 1) {
            log.warn("{} build statuses for commitId \"{}\" and key \"{}\"", new Object[]{deleted, request.getCommitId(), request.getKey()});
        }
        this.ao.create(AoBuildStatus.class, AoBuildStatusDao.toMap(request, now));
        return AoBuildStatusDao.getLegacyBuildStatus(request, now);
    }

    public LegacyBuildStatus set(RepositoryBuildStatusSetRequest request) {
        int deleted = this.ao.deleteWithSQL(AoBuildStatus.class, "CSID = ? AND KEY = ?", new Object[]{request.getCommitId(), request.getKey()});
        if (deleted > 1) {
            log.warn("{} build statuses for commitId \"{}\" and key \"{}\"", new Object[]{deleted, request.getCommitId(), request.getKey()});
        }
        this.ao.create(AoBuildStatus.class, AoBuildStatusDao.toMap(request));
        return AoBuildStatusDao.getLegacyBuildStatus(request);
    }

    public Page<LegacyBuildStatus> findAllBetween(int startId, int endId, PageRequest pageRequest) {
        return this.pageQuery(AoBuildStatus.class, Query.select().where("ID > ? AND ID <= ?", new Object[]{startId, endId}).order("ID ASC"), pageRequest).transform(AoBuildStatusDao::getLegacyBuildStatus);
    }

    public int getMaxId() {
        AoBuildStatus[] buildstatus = (AoBuildStatus[])this.ao.find(AoBuildStatus.class, Query.select().order("ID DESC").limit(1));
        if (buildstatus.length > 0) {
            return buildstatus[0].getId();
        }
        log.info("No build status found, returning 0 for max id");
        return 0;
    }

    private static LegacyBuildStatus getLegacyBuildStatus(RepositoryBuildStatusSetRequest request) {
        return new SimpleLegacyBuildStatus.Builder().commitId(request.getCommitId()).dateAdded(request.getLastUpdated()).description(request.getDescription()).key(request.getKey()).name(request.getName()).state(request.getState()).url(request.getUrl()).build();
    }

    private static LegacyBuildStatus getLegacyBuildStatus(BuildStatusSetRequest request, Date now) {
        return new SimpleLegacyBuildStatus.Builder().commitId(request.getCommitId()).dateAdded(now).description(request.getDescription()).key(request.getKey()).name(request.getName()).state(request.getState()).url(request.getUrl()).build();
    }

    private static LegacyBuildStatus getLegacyBuildStatus(AoBuildStatus aoStatus) {
        return new SimpleLegacyBuildStatus.Builder().commitId(aoStatus.getCommitId()).dateAdded(aoStatus.getDateAdded()).description(aoStatus.getDescription()).key(aoStatus.getKey()).name(aoStatus.getName()).state(aoStatus.getState()).url(aoStatus.getUrl()).build();
    }

    private String transformOrderToQuery(@Nonnull BuildOrder orderBy) {
        switch (orderBy) {
            case STATE: {
                return "STATE ASC, DATE_ADDED DESC";
            }
            case OLDEST: {
                return "DATE_ADDED ASC";
            }
            case NEWEST: {
                return "DATE_ADDED DESC";
            }
        }
        throw new IllegalArgumentException("Unexpected BuildOrder: " + orderBy.toString());
    }
}

