/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.build.status.rest;

import com.atlassian.bitbucket.dmz.build.status.BuildSummary;
import com.atlassian.bitbucket.dmz.build.status.legacy.LegacyBuildStatus;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.stash.internal.build.status.rest.RestBuildStatus;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

@JsonSerialize
public class RestBuildStats
extends RestMapEntity {
    private static final String PROPERTY_CANCELLED = "cancelled";
    private static final String PROPERTY_SUCCESSFUL = "successful";
    private static final String PROPERTY_IN_PROGRESS = "inProgress";
    private static final String PROPERTY_FAILED = "failed";
    private static final String PROPERTY_RESULTS = "results";
    private static final String PROPERTY_UNKNOWN = "unknown";

    public RestBuildStats(BuildSummary stats) {
        this(stats.getCancelledCount(), stats.getSuccessfulCount(), stats.getInProgressCount(), stats.getFailedCount(), stats.getUnknownCount());
    }

    public RestBuildStats(int cancelled, int successful, int inProgress, int failed, int unknown) {
        this.put(PROPERTY_CANCELLED, cancelled);
        this.put(PROPERTY_SUCCESSFUL, successful);
        this.put(PROPERTY_IN_PROGRESS, inProgress);
        this.put(PROPERTY_FAILED, failed);
        this.put(PROPERTY_UNKNOWN, unknown);
    }

    protected RestBuildStats include(LegacyBuildStatus result) {
        if (result != null) {
            this.put(PROPERTY_RESULTS, new RestBuildStatus[]{RestBuildStatus.REST_TRANSFORM.apply(result)});
        }
        return this;
    }

    public int getCancelled() {
        return this.getIntProperty(PROPERTY_CANCELLED);
    }

    public int getSuccessful() {
        return this.getIntProperty(PROPERTY_SUCCESSFUL);
    }

    public int getInProgress() {
        return this.getIntProperty(PROPERTY_IN_PROGRESS);
    }

    public int getFailed() {
        return this.getIntProperty(PROPERTY_FAILED);
    }

    public int getUnknown() {
        return this.getIntProperty(PROPERTY_UNKNOWN);
    }
}

