/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.BuildProperties;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    private static final Logger log = LoggerFactory.getLogger(BuildInfo.class);
    private final String buildNumber;
    private final Date buildTimestamp;
    private final Date commitTimestamp;
    private final BuildProperties properties;

    public BuildInfo(BuildProperties properties) {
        this.properties = properties;
        this.buildNumber = BuildInfo.calculateBuildNumber(properties.getVersion());
        this.buildTimestamp = BuildInfo.parseBuildTimestamp(properties.getTimestamp(), properties.getTimestampFormat());
        this.commitTimestamp = BuildInfo.parseCommitTimestamp(properties.getCommit().getTimestamp());
    }

    @Nonnull
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Nonnull
    public String getBuildVersion() {
        return this.properties.getVersion();
    }

    @Nonnull
    public Date getBuildTimestamp() {
        return new Date(this.buildTimestamp.getTime());
    }

    @Nonnull
    public String getCommitHash() {
        return this.properties.getCommit().getHash();
    }

    @Nonnull
    public String getDisplayCommitHash() {
        return StringUtils.substring((String)this.getCommitHash(), (int)0, (int)7);
    }

    @Nullable
    public Date getCommitTimestamp() {
        return this.commitTimestamp == null ? null : new Date(this.commitTimestamp.getTime());
    }

    public boolean isCompatible(@Nonnull String build) {
        return build.startsWith(this.getMajorVersion()) && build.length() == this.buildNumber.length();
    }

    private static String calculateBuildNumber(String buildVersion) {
        Version version = new Version(buildVersion);
        long major = version.getMajor();
        long minor = version.getMinor();
        long patch = version.getPatch();
        long full = (major * 1000L + minor) * 1000L + patch;
        return String.valueOf(full);
    }

    private static Date parseBuildTimestamp(String timestamp, String format) {
        try {
            return new SimpleDateFormat(format).parse(timestamp);
        }
        catch (Exception e) {
            log.warn("Failed to parse build timestamp [{} ({})], using current time instead", (Object)timestamp, (Object)format);
            return new Date();
        }
    }

    private static Date parseCommitTimestamp(String timestamp) {
        try {
            return new Date(Long.parseLong(timestamp));
        }
        catch (Exception e) {
            log.debug("Failed to parse commit timestamp [{}]", (Object)timestamp);
            return null;
        }
    }

    private String getMajorVersion() {
        return String.valueOf(new Version(this.getBuildVersion()).getMajor());
    }
}

