/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.stash.internal.Initializable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.hibernate.proxy.HibernateProxy;

public class HibernateUtils {
    private HibernateUtils() {
        throw new UnsupportedOperationException();
    }

    public static <B, D extends B> D cast(@Nullable B baseEntity, @Nonnull Class<D> derivedClass) {
        baseEntity = HibernateUtils.unwrap(baseEntity);
        return Objects.requireNonNull(derivedClass, "derivedClass").cast(baseEntity);
    }

    public static <T> T initialize(T entity) {
        if (entity == null) {
            return null;
        }
        if ((entity = HibernateUtils.unwrap(entity)) instanceof Initializable) {
            ((Initializable)entity).initialize();
        }
        return entity;
    }

    public static <T> List<T> initializeList(List<? extends T> list) {
        if (list == null) {
            return null;
        }
        return (List)list.stream().map(HibernateUtils::initialize).collect(MoreCollectors.toImmutableList());
    }

    public static <T> Page<T> initializePage(Page<T> page) {
        if (page == null) {
            return null;
        }
        return page.transform(HibernateUtils::initialize);
    }

    public static <T> Set<T> initializeSet(Set<T> set) {
        if (set == null) {
            return null;
        }
        return (Set)set.stream().map(HibernateUtils::initialize).collect(MoreCollectors.toImmutableSet());
    }

    @Nullable
    public static <B, D extends B> D tryCast(@Nullable B baseEntity, @Nonnull Class<D> derivedClass) {
        baseEntity = HibernateUtils.unwrap(baseEntity);
        return Objects.requireNonNull(derivedClass, "derivedClass").isInstance(baseEntity) ? (D)derivedClass.cast(baseEntity) : null;
    }

    private static <T> T unwrap(T entity) {
        if (entity instanceof HibernateProxy) {
            return (T)((HibernateProxy)entity).getHibernateLazyInitializer().getImplementation();
        }
        return entity;
    }
}

