/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.activity;

import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.pull.InternalPullRequestMergeActivity;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class IntegrityCheckMergeActivity {
    private final PullRequestRef fromRef;
    private final String mergeCommit;
    private final long pullRequestId;
    private final int pullRequestVersion;
    private final Repository scopeRepository;
    private final PullRequestRef toRef;

    public IntegrityCheckMergeActivity(@Nonnull InternalPullRequestMergeActivity activity) {
        this.fromRef = activity.getPullRequest().getFromRef();
        this.mergeCommit = activity.getHash();
        this.pullRequestId = activity.getPullRequest().getId();
        this.pullRequestVersion = activity.getPullRequest().getVersion();
        this.scopeRepository = activity.getPullRequest().getScopeRepository();
        this.toRef = activity.getPullRequest().getToRef();
    }

    @Nonnull
    public PullRequestRef getFromRef() {
        return this.fromRef;
    }

    @Nullable
    public String getMergeCommit() {
        return this.mergeCommit;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public int getPullRequestVersion() {
        return this.pullRequestVersion;
    }

    @Nonnull
    public Repository getScopeRepository() {
        return this.scopeRepository;
    }

    @Nonnull
    public PullRequestRef getToRef() {
        return this.toRef;
    }
}

