/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.activity;

import com.atlassian.bitbucket.activity.Activity;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@DiscriminatorColumn(name="activity_type", discriminatorType=DiscriminatorType.INTEGER)
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="sta_activity", indexes={@Index(name="idx_sta_activity_created_time", columnList="created_timestamp"), @Index(name="idx_sta_activity_type", columnList="activity_type"), @Index(name="idx_sta_activity_user", columnList="user_id")})
@TableGenerator(allocationSize=37, pkColumnValue="sta_activity", name="activityIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public abstract class InternalActivity
implements Activity,
Initializable {
    public static final String ID_GEN = "activityIdGenerator";
    public static final String TABLE = "sta_activity";
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="activityIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="activity_type", nullable=false, updatable=false)
    private final int type;
    @JoinColumn(name="user_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_activity_user"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser user;

    protected InternalActivity() {
        this.createdDate = null;
        this.id = 0L;
        this.type = -1;
    }

    protected InternalActivity(AbstractActivityBuilder<?, ?> builder) {
        this.createdDate = Objects.requireNonNull(builder, (String)"builder").createdDate;
        this.id = builder.id;
        this.user = builder.user;
        DiscriminatorValue value = this.getClass().getAnnotation(DiscriminatorValue.class);
        if (value == null) {
            throw new IllegalStateException("Activity class [" + this.getClass().getName() + "] does not have a DiscriminatorValue annotation");
        }
        this.type = Integer.parseInt(value.value());
    }

    protected InternalActivity(Date createdDate, long id, int type, InternalApplicationUser user) {
        this.createdDate = createdDate;
        this.id = id;
        this.type = type;
        this.user = user;
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public long getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    @Override
    public void initialize() {
        this.user = HibernateUtils.initialize(this.getUser());
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    @Nonnull
    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("user", (Object)this.user);
    }

    public static abstract class AbstractActivityBuilder<B extends AbstractActivityBuilder<B, A>, A extends InternalActivity>
    extends BuilderSupport {
        private Date createdDate;
        private long id;
        private InternalApplicationUser user;

        protected AbstractActivityBuilder() {
            this.createdDate = new Date();
            this.id = 0L;
        }

        protected AbstractActivityBuilder(@Nonnull A activity) {
            Objects.requireNonNull(activity, "activity");
            this.createdDate = ((InternalActivity)activity).getCreatedDate();
            this.id = ((InternalActivity)activity).getId();
            this.user = ((InternalActivity)activity).getUser();
        }

        @Nonnull
        public abstract A build();

        @Nonnull
        public B createdDate(@Nonnull Date value) {
            this.createdDate = Objects.requireNonNull(value, "createdDate");
            return this.self();
        }

        @Nonnull
        public B id(long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public B user(@Nonnull InternalApplicationUser value) {
            this.user = Objects.requireNonNull(value, "user");
            return this.self();
        }

        @Nonnull
        protected abstract B self();
    }
}

