/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.attachment;

import com.atlassian.bitbucket.attachment.Attachment;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Cacheable
@Entity
@Table(name="bb_attachment")
@TableGenerator(allocationSize=20, pkColumnValue="bb_attachment", name="attachmentIdGen", table="id_sequence", indexes={@Index(name="idx_attachment_repo_id", columnList="repository_id")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalAttachment
implements Initializable,
Attachment {
    public static final String ID_GEN = "attachmentIdGen";
    public static final String TABLE = "bb_attachment";
    private static final int FILENAME_LENGTH = 255;
    @Column(name="filename", nullable=false, length=255)
    @RequiredString(size=255)
    private final String filename;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="attachmentIdGen", strategy=GenerationType.TABLE)
    private final long id;
    @JoinColumn(name="repository_id", foreignKey=@ForeignKey(name="fk_attachment_repo"))
    @ManyToOne(fetch=FetchType.LAZY)
    private InternalRepository repository;

    protected InternalAttachment() {
        this.filename = null;
        this.id = 0L;
        this.repository = null;
    }

    private InternalAttachment(@Nonnull Builder builder) {
        this.filename = builder.filename;
        this.id = builder.id;
        this.repository = builder.repository;
    }

    @Nonnull
    public String getFilename() {
        return this.filename;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
    }

    public static class Builder
    extends BuilderSupport {
        private final String filename;
        private final long id;
        private final InternalRepository repository;

        public Builder(@Nonnull String filename, @Nonnull InternalRepository repository) {
            this.filename = Builder.requireNonBlank((String)filename, (String)"filename");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.id = 0L;
        }

        @Nonnull
        public InternalAttachment build() {
            return new InternalAttachment(this);
        }
    }
}

