/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.attachment;

import com.atlassian.bitbucket.attachment.AttachmentMetadata;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.attachment.InternalAttachment;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="bb_attachment_metadata")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalAttachmentMetadata
implements AttachmentMetadata,
Initializable {
    public static final int MAX_METADATA_LENGTH = 32768;
    public static final String TABLE = "bb_attachment_metadata";
    @Id
    @Column(name="attachment_id", nullable=false)
    private final long attachmentId;
    @JoinColumn(name="attachment_id", nullable=false)
    @OneToOne(cascade={CascadeType.MERGE}, fetch=FetchType.LAZY, optional=false)
    private InternalAttachment attachment;
    @Column(name="metadata", nullable=false)
    @Lob
    @RequiredString(size=32768)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String metadata;

    protected InternalAttachmentMetadata() {
        this.attachmentId = 0L;
        this.metadata = null;
        this.attachment = null;
    }

    private InternalAttachmentMetadata(@Nonnull Builder builder) {
        this.attachmentId = builder.attachmentId;
        this.metadata = builder.metadata;
        this.attachment = builder.attachment;
    }

    @Nonnull
    public InternalAttachment getAttachment() {
        return this.attachment;
    }

    public long getAttachmentId() {
        return this.attachmentId;
    }

    @Nonnull
    public String getMetadata() {
        return this.metadata;
    }

    @Override
    public void initialize() {
        this.attachment = HibernateUtils.initialize(this.attachment);
    }

    public static class Builder
    extends BuilderSupport {
        private final InternalAttachment attachment;
        private final long attachmentId;
        private final String metadata;

        public Builder(@Nonnull InternalAttachment attachment, @Nonnull String metadata) {
            this.attachment = Objects.requireNonNull(attachment, "attachment");
            this.metadata = Builder.checkNotBlank((String)metadata, (String)"metadata");
            this.attachmentId = attachment.getId();
        }

        @Nonnull
        public InternalAttachmentMetadata build() {
            return new InternalAttachmentMetadata(this);
        }
    }
}

