/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hibernate.Hibernate;

@Entity
@Table(name="sta_remember_me_token")
@TableGenerator(allocationSize=20, pkColumnValue="sta_remember_me_token", name="rememberMeTokenIdGenerator", table="id_sequence")
public class InternalRememberMeToken
implements Initializable {
    public static final String ID_GEN = "rememberMeTokenIdGenerator";
    static final String TABLE = "sta_remember_me_token";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="rememberMeTokenIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="series", nullable=false, updatable=false)
    @RequiredString(size=64)
    private final String series;
    @Column(name="token", nullable=false, updatable=false)
    @RequiredString(size=64)
    private final String token;
    @Column(name="claimed", nullable=false)
    private final boolean claimed;
    @Column(name="expiry_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date expiryDate;
    @Column(name="claimed_address")
    @OptionalString(size=255)
    private final String remoteAddress;
    @JoinColumn(name="user_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalApplicationUser user;

    protected InternalRememberMeToken() {
        this.claimed = false;
        this.expiryDate = null;
        this.id = 0L;
        this.remoteAddress = null;
        this.series = null;
        this.token = null;
        this.user = null;
    }

    private InternalRememberMeToken(Builder builder) {
        this.id = builder.id;
        this.claimed = builder.claimed;
        this.expiryDate = builder.expiryDate;
        this.remoteAddress = builder.remoteAddress;
        this.series = builder.series;
        this.token = builder.token;
        this.user = builder.user;
    }

    @Nonnull
    public Date getExpiryDate() {
        return new Date(this.expiryDate.getTime());
    }

    public long getId() {
        return this.id;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Nonnull
    public String getSeries() {
        return this.series;
    }

    @Nonnull
    public String getToken() {
        return this.token;
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    @Override
    public void initialize() {
        Hibernate.initialize((Object)this.getUser());
    }

    public boolean isClaimed() {
        return this.claimed;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiryDate.getTime();
    }

    public static class Builder {
        private boolean claimed;
        private Date expiryDate;
        private long id;
        private String remoteAddress;
        private String series;
        private String token;
        private InternalApplicationUser user;

        public Builder() {
            this.id = 0L;
        }

        public Builder(@Nonnull InternalRememberMeToken token) {
            Objects.requireNonNull(token, "token");
            this.claimed = token.claimed;
            this.expiryDate = token.expiryDate;
            this.id = token.id;
            this.remoteAddress = token.remoteAddress;
            this.series = token.series;
            this.token = token.token;
            this.user = token.user;
        }

        @Nonnull
        public InternalRememberMeToken build() {
            Preconditions.checkState((this.series != null ? 1 : 0) != 0, (Object)"Series must be set");
            Preconditions.checkState((this.token != null ? 1 : 0) != 0, (Object)"Token must be set");
            return new InternalRememberMeToken(this);
        }

        @Nonnull
        public Builder claimed() {
            this.claimed = true;
            return this.self();
        }

        @Nonnull
        public Builder expiresAfter(long time, @Nonnull TimeUnit timeUnit) {
            Objects.requireNonNull(timeUnit, "timeUnit");
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.add(13, Ints.saturatedCast((long)timeUnit.toSeconds(time)));
            this.expiryDate = calendar.getTime();
            return this.self();
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public Builder remoteAddress(@Nonnull String value) {
            this.remoteAddress = Objects.requireNonNull(value, "remoteAddress");
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public Builder series(@Nonnull String value) {
            this.series = Objects.requireNonNull(value, "series");
            return this.self();
        }

        @Nonnull
        public Builder token(@Nonnull String value) {
            this.token = Objects.requireNonNull(value, "token");
            return this.self();
        }

        @Nonnull
        public Builder user(@Nonnull InternalApplicationUser value) {
            this.user = Objects.requireNonNull(value, "user");
            return this.self();
        }
    }
}

