/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.autodecline;

import com.atlassian.bitbucket.dmz.autodecline.AutoDeclineSettings;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.Objects;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.MetaValue;

@Entity
@Table(name="bb_auto_decline_settings")
@TableGenerator(allocationSize=20, pkColumnValue="bb_auto_decline_settings", name="autoDeclineIdGenerator", table="id_sequence")
public class InternalAutoDeclineSettings
implements AutoDeclineSettings,
Initializable {
    public static final String ID_GEN = "autoDeclineIdGenerator";
    public static final String TABLE = "bb_auto_decline_settings";
    @Column(name="enabled", nullable=false)
    private final boolean enabled;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="autoDeclineIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="inactivity_weeks", nullable=false)
    private final int inactivityWeeks;
    @JoinColumn(name="scope_id", updatable=false, nullable=false)
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="scope_type"))
    @AnyMetaDef(idType="integer", metaType="integer", metaValues={@MetaValue(targetEntity=InternalNormalProject.class, value="1"), @MetaValue(targetEntity=InternalPersonalProject.class, value="2"), @MetaValue(targetEntity=InternalRepository.class, value="3")})
    private final Scopeable scope;

    protected InternalAutoDeclineSettings() {
        this.id = 0L;
        this.inactivityWeeks = 0;
        this.enabled = false;
        this.scope = null;
    }

    private InternalAutoDeclineSettings(Builder builder) {
        this.id = builder.id;
        this.inactivityWeeks = builder.inactivityWeeks;
        this.enabled = builder.enabled;
        this.scope = builder.scope;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public long getId() {
        return this.id;
    }

    public int getInactivityWeeks() {
        return this.inactivityWeeks;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope == null ? Scopes.global() : this.scope.toScope();
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.scope);
    }

    public static class Builder {
        private final long id;
        private final Scopeable scope;
        private boolean enabled;
        private int inactivityWeeks;

        public Builder(int inactivityWeeks, @Nonnull Scope scope, boolean enabled) {
            Objects.requireNonNull(scope, "scope");
            this.enabled = enabled;
            this.id = 0L;
            this.inactivityWeeks = inactivityWeeks;
            this.scope = Scopeable.fromScope(scope);
        }

        public Builder(@Nonnull InternalAutoDeclineSettings settings) {
            this.enabled = settings.getEnabled();
            this.id = settings.id;
            this.inactivityWeeks = settings.getInactivityWeeks();
            this.scope = Scopeable.fromScope(settings.getScope());
        }

        @Nonnull
        public InternalAutoDeclineSettings build() {
            return new InternalAutoDeclineSettings(this);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder inactivityWeeks(int inactivityWeeks) {
            this.inactivityWeeks = inactivityWeeks;
            return this;
        }
    }
}

