/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.banner;

import com.atlassian.bitbucket.dmz.admin.banner.AnnouncementBanner;
import com.atlassian.bitbucket.dmz.admin.banner.AnnouncementBannerAudience;
import com.atlassian.bitbucket.dmz.admin.banner.SetAnnouncementBannerRequest;
import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_announcement_banner")
public class InternalAnnouncementBanner
implements AnnouncementBanner {
    public static final long BANNER_ID = 1L;
    public static final String TABLE = "bb_announcement_banner";
    @Column(name="audience", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.dmz.admin.banner.AnnouncementBannerAudience")})
    private final AnnouncementBannerAudience audience;
    @Column(name="enabled", nullable=false)
    private final boolean enabled;
    @Column(name="id", nullable=false, unique=true)
    @Id
    private final long id;
    @Column(name="message", length=4000, nullable=false)
    private final String message;

    protected InternalAnnouncementBanner() {
        this.id = 1L;
        this.message = "";
        this.enabled = false;
        this.audience = AnnouncementBannerAudience.ALL;
    }

    private InternalAnnouncementBanner(Builder builder) {
        this.id = builder.id;
        this.enabled = builder.enabled;
        this.audience = builder.audience;
        this.message = builder.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalAnnouncementBanner oBanner = (InternalAnnouncementBanner)o;
        return this.audience == oBanner.audience && this.id == oBanner.id && this.enabled == oBanner.enabled && this.message.equals(oBanner.message);
    }

    @Nonnull
    public AnnouncementBannerAudience getAudience() {
        return this.audience;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public int hashCode() {
        return Objects.hash(this.audience, this.id, this.enabled, this.message);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return "InternalAnnouncementBanner{audience=" + String.valueOf(this.audience) + ", id=" + this.id + ", enabled=" + this.enabled + ", message='" + this.message + "'}";
    }

    public static class Builder
    extends BuilderSupport {
        private AnnouncementBannerAudience audience;
        private boolean enabled;
        private long id;
        private String message;

        public Builder() {
            this.id = 1L;
        }

        public Builder(@Nonnull AnnouncementBanner banner) {
            Objects.requireNonNull(banner, "banner");
            this.id = 1L;
            this.audience = banner.getAudience();
            this.enabled = banner.isEnabled();
            this.message = banner.getMessage();
        }

        public Builder(@Nonnull SetAnnouncementBannerRequest request) {
            Objects.requireNonNull(request, "request");
            this.id = 1L;
            this.audience = request.getAudience();
            this.enabled = request.isEnabled();
            this.message = request.getMessage();
        }

        public Builder audience(@Nonnull AnnouncementBannerAudience audience) {
            this.audience = Objects.requireNonNull(audience, "audience");
            return this.self();
        }

        @Nonnull
        public InternalAnnouncementBanner build() {
            return new InternalAnnouncementBanner(this);
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this.self();
        }

        public Builder message(@Nonnull String message) {
            this.message = Objects.requireNonNull(message, "message");
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

