/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentOperations;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentState;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.InternalCommentThread;
import com.atlassian.stash.internal.property.AbstractPropertySupport;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="bb_comment", indexes={@Index(name="idx_bb_comment_author", columnList="author_id"), @Index(name="idx_bb_comment_resolver", columnList="resolver_id"), @Index(name="idx_bb_comment_severity", columnList="severity"), @Index(name="idx_bb_comment_state", columnList="state"), @Index(name="idx_bb_comment_thread", columnList="thread_id")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalComment
extends AbstractPropertySupport
implements Comment,
Initializable {
    public static final String ID_GEN = "commentIdGenerator";
    public static final String TABLE = "bb_comment";
    @JoinColumn(name="author_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_comment_author"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser author;
    @OneToMany(mappedBy="parent", targetEntity=InternalComment.class)
    @OrderBy(value="createdDate")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @OptimisticLock(excluded=true)
    private final List<Comment> comments = new ArrayList<Comment>();
    @Column(name="created_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="commentIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="bb_comment", name="commentIdGenerator", table="id_sequence")
    private final long id;
    @JoinTable(name="bb_comment_parent", joinColumns={@JoinColumn(name="comment_id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="parent_id", nullable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalComment parent;
    @Column(name="resolved_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date resolvedDate;
    @JoinColumn(name="resolver_id", nullable=false, unique=true, foreignKey=@ForeignKey(name="fk_bb_comment_resolver"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser resolver;
    @Column(name="severity", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.comment.CommentSeverity")})
    private CommentSeverity severity;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.comment.CommentState")})
    private CommentState state;
    @Column(name="comment_text", nullable=false)
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String text;
    @JoinColumn(name="thread_id", foreignKey=@ForeignKey(name="fk_bb_comment_thread"))
    @ManyToOne(fetch=FetchType.LAZY)
    @OptimisticLock(excluded=true)
    private InternalCommentThread thread;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;
    @Transient
    private CommentOperations permittedOperations;
    @Transient
    private Predicate<Comment> replyFilter;

    protected InternalComment() {
        this.createdDate = null;
        this.id = 0L;
        this.parent = null;
        this.resolvedDate = null;
        this.severity = CommentSeverity.NORMAL;
        this.state = CommentState.OPEN;
        this.text = null;
        this.thread = null;
        this.updatedDate = null;
        this.version = 0;
    }

    private InternalComment(Builder builder) {
        super(builder);
        this.id = builder.id;
        this.author = builder.author;
        this.createdDate = builder.createdDate;
        this.parent = InternalComment.notSelf(this.id, builder.parent);
        this.resolvedDate = builder.resolvedDate;
        this.resolver = builder.resolver;
        this.severity = builder.severity;
        this.state = builder.state;
        this.text = builder.text;
        this.updatedDate = builder.updatedDate;
        this.version = builder.version;
        this.thread = builder.parent == null ? builder.thread : builder.parent.getThread();
    }

    @Nonnull
    public Optional<CommentThreadDiffAnchor> getAnchor() {
        return this.thread.getAnchor();
    }

    @Nonnull
    public InternalApplicationUser getAuthor() {
        return this.author;
    }

    @Nonnull
    public List<Comment> getComments() {
        if (this.replyFilter == null) {
            return Collections.unmodifiableList(this.comments);
        }
        return (List)this.comments.stream().filter(this.replyFilter).collect(MoreCollectors.toImmutableList());
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public long getId() {
        return this.id;
    }

    public InternalComment getParent() {
        return this.parent;
    }

    @Nullable
    public Date getResolvedDate() {
        return this.resolvedDate;
    }

    @Nullable
    public InternalApplicationUser getResolver() {
        return this.resolver;
    }

    @Nonnull
    public CommentSeverity getSeverity() {
        return this.severity;
    }

    @Nonnull
    public CommentState getState() {
        return this.state;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    @Nonnull
    public InternalCommentThread getThread() {
        return this.thread;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public int getVersion() {
        return this.version;
    }

    @Nonnull
    public Optional<CommentOperations> getPermittedOperations() {
        return Optional.ofNullable(this.permittedOperations);
    }

    public boolean hasPermittedOperations() {
        return this.permittedOperations != null;
    }

    @Override
    public void initialize() {
        this.initialize(true);
    }

    public void initialize(boolean recursive) {
        this.author = HibernateUtils.initialize(this.getAuthor());
        this.resolver = HibernateUtils.initialize(this.getResolver());
        if (recursive) {
            Hibernate.initialize(this.getComments());
            for (Comment comment : this.getComments()) {
                ((InternalComment)comment).initialize(true);
            }
        }
    }

    public boolean isPending() {
        return this.getState() == CommentState.PENDING;
    }

    public void setPermittedOperations(@Nonnull CommentOperations operations) {
        if (this.permittedOperations != null) {
            throw new IllegalStateException("You cannot set permitted operations after they've been initialized");
        }
        this.permittedOperations = operations;
    }

    public void setReplyFilter(@Nonnull Predicate<Comment> replyFilter) {
        this.replyFilter = Objects.requireNonNull(replyFilter, "replyFilter");
        this.getComments().stream().map(comment -> (InternalComment)comment).forEach(reply -> reply.setReplyFilter(replyFilter));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("author", (Object)this.author).add("severity", (Object)this.severity).add("text", (Object)StringUtils.abbreviate((String)this.text, (int)20)).toString();
    }

    @Override
    protected boolean hasProperties() {
        return super.hasProperties();
    }

    void addComment(@Nonnull InternalComment comment) {
        this.comments.add(comment);
    }

    void removeComment(@Nonnull InternalComment comment) {
        this.comments.remove(comment);
    }

    private static InternalComment notSelf(Long id, InternalComment comment) {
        if (comment != null && !com.google.common.base.Objects.equal((Object)comment.getId(), (Object)id)) {
            return comment;
        }
        return null;
    }

    public static class Builder
    extends AbstractPropertySupport.PropertyBuilderSupport<Builder> {
        private InternalApplicationUser author;
        private Date createdDate;
        private long id;
        private InternalComment parent;
        private Date resolvedDate;
        private InternalApplicationUser resolver;
        private CommentSeverity severity;
        private CommentState state;
        private String text;
        private InternalCommentThread thread;
        private Date updatedDate;
        private int version;

        public Builder() {
            this.id = 0L;
            this.createdDate = this.updatedDate = new Date();
            this.severity = CommentSeverity.NORMAL;
            this.state = CommentState.OPEN;
        }

        public Builder(@Nonnull InternalComment comment) {
            super(Objects.requireNonNull(comment, "comment"));
            this.author = comment.getAuthor();
            this.createdDate = comment.getCreatedDate();
            this.id = comment.getId();
            this.parent = comment.getParent();
            this.resolver = comment.getResolver();
            this.resolvedDate = comment.getResolvedDate();
            this.severity = comment.getSeverity();
            this.state = comment.getState();
            this.text = comment.getText();
            this.thread = comment.getThread();
            this.updatedDate = comment.getUpdatedDate();
            this.version = comment.getVersion();
        }

        @Nonnull
        public Builder author(@Nonnull InternalApplicationUser value) {
            this.author = Objects.requireNonNull(value, "author");
            return this;
        }

        @Nonnull
        public InternalComment build() {
            return new InternalComment(this);
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date date) {
            this.createdDate = Objects.requireNonNull(date, "date");
            return this;
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder parent(@Nullable InternalComment value) {
            this.parent = value;
            return this;
        }

        @Nonnull
        public Builder resolve(@Nonnull InternalApplicationUser value) {
            if (this.resolvedDate == null) {
                this.resolvedDate = new Date();
            }
            this.resolver = Objects.requireNonNull(value, "resolver");
            this.state = CommentState.RESOLVED;
            return this;
        }

        @Nonnull
        public Builder resolvedDate(@Nonnull Date value) {
            this.resolvedDate = Objects.requireNonNull(value, "resolvedDate");
            return this;
        }

        @Nonnull
        public Builder severity(@Nonnull CommentSeverity value) {
            this.severity = Objects.requireNonNull(value, "severity");
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull CommentState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }

        @Nonnull
        public Builder text(@Nonnull String value) {
            this.text = StringUtils.remove((String)Builder.requireNonBlank((String)value, (String)"text"), (char)'\u0000');
            return this;
        }

        @Nonnull
        public Builder thread(@Nonnull InternalCommentThread value) {
            this.thread = Objects.requireNonNull(value, "thread");
            return this;
        }

        @Nonnull
        public Builder unresolve() {
            this.resolvedDate = null;
            this.resolver = null;
            this.state = CommentState.OPEN;
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Date value) {
            this.updatedDate = Objects.requireNonNull(value, "updatedDate");
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

