/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.comment.CommentThread;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentThreadDiffAnchor;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.MetaValue;

@Cacheable
@Entity
@Table(name="bb_comment_thread", indexes={@Index(name="idx_bb_com_thr_commentable", columnList="commentable_type, commentable_id"), @Index(name="idx_bb_com_thr_from_hash", columnList="from_hash"), @Index(name="idx_bb_com_thr_to_hash", columnList="to_hash"), @Index(name="idx_bb_com_thr_to_path", columnList="to_path"), @Index(name="idx_bb_com_thr_diff_type", columnList="diff_type")})
@TableGenerator(allocationSize=20, pkColumnValue="bb_comment_thread", name="commentThreadIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalCommentThread
implements CommentThread,
Initializable {
    public static final String ID_GEN = "commentThreadIdGenerator";
    public static final String TABLE = "bb_comment_thread";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="commentThreadIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Embedded
    private final InternalCommentThreadDiffAnchor anchor;
    @JoinColumn(name="commentable_id", nullable=false, updatable=false)
    @Any(fetch=FetchType.LAZY, optional=false, metaColumn=@Column(name="commentable_type", nullable=false))
    @AnyMetaDef(idType="long", metaType="integer", metaValues={@MetaValue(targetEntity=InternalCommitDiscussion.class, value="1"), @MetaValue(targetEntity=InternalPullRequest.class, value="2")})
    private InternalCommentable commentable;
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;
    @OneToOne(fetch=FetchType.LAZY, targetEntity=InternalComment.class, cascade={CascadeType.REMOVE})
    @JoinTable(name="bb_thread_root_comment", joinColumns={@JoinColumn(name="thread_id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="comment_id", nullable=false, updatable=false)})
    private InternalComment rootComment;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date updatedDate;
    @Column(name="resolved")
    private final Boolean resolved;
    @Column(name="resolved_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date resolvedDate;
    @JoinColumn(name="resolver_id", nullable=false, unique=true, foreignKey=@ForeignKey(name="fk_bb_comment_thread_resolver"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalApplicationUser resolver;

    protected InternalCommentThread() {
        this.id = 0L;
        this.anchor = null;
        this.commentable = null;
        this.createdDate = null;
        this.resolved = false;
        this.resolvedDate = null;
        this.resolver = null;
        this.rootComment = null;
        this.updatedDate = null;
        this.version = 0;
    }

    private InternalCommentThread(Builder builder) {
        this.id = builder.id;
        this.anchor = builder.anchor;
        this.resolved = builder.resolved;
        this.resolvedDate = builder.resolvedDate;
        this.resolver = builder.resolver;
        this.rootComment = builder.rootComment;
        this.commentable = builder.commentable;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
        this.version = builder.version;
    }

    @Nonnull
    public Optional<CommentThreadDiffAnchor> getAnchor() {
        return Optional.ofNullable(this.anchor);
    }

    @Nonnull
    public InternalCommentable getCommentable() {
        return this.commentable;
    }

    @Nonnull
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public long getId() {
        return this.id;
    }

    public boolean isResolved() {
        return this.resolved == null ? false : this.resolved;
    }

    @Nullable
    public Date getResolvedDate() {
        return this.resolvedDate;
    }

    @Nullable
    public InternalApplicationUser getResolver() {
        return this.resolver;
    }

    @Nonnull
    public InternalComment getRootComment() {
        return this.rootComment;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void initialize() {
        this.commentable = HibernateUtils.initialize(this.getCommentable());
        this.resolver = HibernateUtils.initialize(this.getResolver());
        this.rootComment = HibernateUtils.initialize(this.getRootComment());
    }

    public boolean isAnchored() {
        return this.anchor != null;
    }

    public static class Builder {
        private final InternalCommentable commentable;
        private InternalCommentThreadDiffAnchor anchor;
        private Date createdDate;
        private long id;
        private boolean resolved;
        private Date resolvedDate;
        private InternalApplicationUser resolver;
        private InternalComment rootComment;
        private Date updatedDate;
        private int version;

        public Builder(@Nonnull InternalCommentable commentable, @Nonnull InternalComment rootComment) {
            this.commentable = Objects.requireNonNull(commentable, "commentable");
            this.rootComment = Objects.requireNonNull(rootComment, "rootComment");
            this.createdDate = this.updatedDate = rootComment.getCreatedDate();
            this.id = 0L;
            this.resolved = false;
        }

        public Builder(@Nonnull InternalCommentThread thread) {
            Objects.requireNonNull(thread, "thread");
            this.anchor = thread.getAnchor().orElse(null);
            this.commentable = thread.getCommentable();
            this.createdDate = thread.getCreatedDate();
            this.id = thread.getId();
            this.resolved = thread.isResolved();
            this.resolvedDate = thread.getResolvedDate();
            this.resolver = thread.getResolver();
            this.rootComment = thread.getRootComment();
            this.updatedDate = thread.getUpdatedDate();
            this.version = thread.getVersion();
        }

        @Nonnull
        public InternalCommentThread build() {
            return new InternalCommentThread(this);
        }

        @Nonnull
        public Builder anchor(@Nullable InternalCommentThreadDiffAnchor value) {
            this.anchor = value;
            return this;
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder resolve(@Nonnull InternalApplicationUser value) {
            Objects.requireNonNull(value, "resolver");
            return this.resolve(new Date(), value);
        }

        @Nonnull
        public Builder resolve(Date dateValue, InternalApplicationUser resolverValue) {
            this.requireBothNonNullOrBothNull(dateValue, resolverValue);
            this.resolved = true;
            this.resolvedDate = dateValue;
            this.resolver = resolverValue;
            return this;
        }

        @Nonnull
        public Builder unresolve() {
            this.resolved = false;
            this.resolvedDate = null;
            this.resolver = null;
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Date value) {
            this.updatedDate = Objects.requireNonNull(value, "updatedDate");
            return this;
        }

        @Nonnull
        public Builder self() {
            return this;
        }

        private void requireBothNonNullOrBothNull(Date dateValue, InternalApplicationUser resolverValue) {
            if (dateValue != null) {
                Objects.requireNonNull(resolverValue, "resolver");
            }
            if (resolverValue != null) {
                Objects.requireNonNull(dateValue, "date");
            }
        }
    }
}

