/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.AddLineCommentRequest;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.LineNumberRange;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.dmz.comment.AddMultilineCommentRequest;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.validation.groups.Create;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Embeddable
public class InternalCommentThreadDiffAnchor
implements CommentThreadDiffAnchor {
    @Column(name="diff_type", nullable=false, updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType")})
    private final CommentThreadDiffAnchorType diffType;
    @Column(name="dst_span_end")
    private final Integer dstSpanEnd;
    @Column(name="dst_span_start")
    private final Integer dstSpanStart;
    @Column(name="file_type", updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.content.DiffFileType")})
    private final DiffFileType fileType;
    @Column(name="from_hash", length=40)
    @OptionalString(minimumSize=40, size=40, groups={Create.class})
    private final String fromHash;
    @Column(name="line_number", nullable=false)
    private final int line;
    @Column(name="line_type", updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.content.DiffSegmentType")})
    private final DiffSegmentType lineType;
    @Column(name="multiline_start_line")
    private final Integer multilineStartLine;
    @Column(name="multiline_start_line_type", updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.content.DiffSegmentType")})
    private final DiffSegmentType multilineStartLineType;
    @Column(name="is_orphaned", nullable=false)
    private final boolean orphaned;
    @Column(name="to_path", nullable=false, length=1024, updatable=false)
    @RequiredString(size=1024, groups={Create.class})
    private final String path;
    @Column(name="from_path", length=1024, updatable=false)
    @OptionalString(size=1024, groups={Create.class})
    private final String srcPath;
    @Column(name="src_span_end")
    private final Integer srcSpanEnd;
    @Column(name="src_span_start")
    private final Integer srcSpanStart;
    @Column(name="to_hash", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40, groups={Create.class})
    private final String toHash;

    protected InternalCommentThreadDiffAnchor() {
        this.diffType = null;
        this.fileType = null;
        this.toHash = null;
        this.srcPath = null;
        this.path = null;
        this.fromHash = null;
        this.line = 0;
        this.lineType = null;
        this.multilineStartLine = null;
        this.multilineStartLineType = null;
        this.orphaned = false;
        this.srcSpanEnd = null;
        this.srcSpanStart = null;
        this.dstSpanEnd = null;
        this.dstSpanStart = null;
    }

    private InternalCommentThreadDiffAnchor(Builder builder) {
        this.diffType = Objects.requireNonNull(builder.diffType, "diffType");
        this.fileType = builder.fileType;
        this.fromHash = builder.fromHash;
        this.line = builder.line;
        this.lineType = builder.lineType;
        this.multilineStartLine = builder.multilineStartLine;
        this.multilineStartLineType = builder.multilineStartLineType;
        this.orphaned = builder.orphaned;
        this.path = builder.path;
        this.srcPath = builder.srcPath;
        this.srcSpanEnd = builder.srcSpanEnd;
        this.srcSpanStart = builder.srcSpanStart;
        this.dstSpanEnd = builder.dstSpanEnd;
        this.dstSpanStart = builder.dstSpanStart;
        this.toHash = builder.toHash;
    }

    @Nonnull
    public CommentThreadDiffAnchorType getDiffType() {
        return this.diffType;
    }

    @Nonnull
    public Optional<Integer> getDstSpanEnd() {
        return Optional.ofNullable(this.dstSpanEnd);
    }

    @Nonnull
    public Optional<Integer> getDstSpanStart() {
        return Optional.ofNullable(this.dstSpanStart);
    }

    @Nonnull
    public Optional<DiffFileType> getFileType() {
        return Optional.ofNullable(this.fileType);
    }

    @Nonnull
    public Optional<String> getFromHash() {
        return Optional.ofNullable(this.fromHash);
    }

    public int getLine() {
        return this.line;
    }

    @Nonnull
    public Optional<DiffSegmentType> getLineType() {
        return Optional.ofNullable(this.lineType);
    }

    @Nonnull
    public Optional<LineNumberRange> getMultilineDestinationRange() {
        if (this.dstSpanStart == null || this.dstSpanEnd == null) {
            return Optional.empty();
        }
        return Optional.of(new LineNumberRange(this.dstSpanStart.intValue(), this.dstSpanEnd.intValue()));
    }

    @Nonnull
    public Optional<LineNumberRange> getMultilineSourceRange() {
        if (this.srcSpanStart == null || this.srcSpanEnd == null) {
            return Optional.empty();
        }
        return Optional.of(new LineNumberRange(this.srcSpanStart.intValue(), this.srcSpanEnd.intValue()));
    }

    @Nonnull
    public Optional<Integer> getMultilineStartLine() {
        return Optional.ofNullable(this.multilineStartLine);
    }

    @Nonnull
    public Optional<DiffSegmentType> getMultilineStartLineType() {
        return Optional.ofNullable(this.multilineStartLineType);
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Optional<String> getSrcPath() {
        return Optional.ofNullable(this.srcPath);
    }

    @Nonnull
    public Optional<Integer> getSrcSpanEnd() {
        return Optional.ofNullable(this.srcSpanEnd);
    }

    @Nonnull
    public Optional<Integer> getSrcSpanStart() {
        return Optional.ofNullable(this.srcSpanStart);
    }

    @Nonnull
    public String getToHash() {
        return this.toHash;
    }

    public boolean isFileAnchor() {
        return this.line == 0 || this.lineType == null;
    }

    public boolean isLineAnchor() {
        return this.line > 0 && this.lineType != null;
    }

    public boolean isMultilineAnchor() {
        return this.isLineAnchor() && (this.srcSpanStart != null && this.srcSpanEnd != null || this.dstSpanStart != null && this.dstSpanEnd != null) && this.multilineStartLine != null && this.multilineStartLineType != null;
    }

    public boolean isOrphaned() {
        return this.orphaned;
    }

    public static class Builder {
        private CommentThreadDiffAnchorType diffType;
        private Integer dstSpanEnd;
        private Integer dstSpanStart;
        private DiffFileType fileType;
        private String fromHash;
        private int line;
        private DiffSegmentType lineType;
        private Integer multilineStartLine;
        private DiffSegmentType multilineStartLineType;
        private boolean orphaned;
        private String path;
        private String srcPath;
        private Integer srcSpanEnd;
        private Integer srcSpanStart;
        private String toHash;

        public Builder(@Nonnull CommentThreadDiffAnchorType diffType, @Nonnull String path, @Nonnull String toHash) {
            Preconditions.checkArgument((!Objects.requireNonNull(path, "path").trim().isEmpty() ? 1 : 0) != 0, (Object)"A path is required.");
            Preconditions.checkArgument((!Objects.requireNonNull(toHash, "toHash").trim().isEmpty() ? 1 : 0) != 0, (Object)"The \"to\" hash is required.");
            this.diffType = Objects.requireNonNull(diffType, "diffType");
            this.path = path;
            this.toHash = toHash;
        }

        public Builder(@Nonnull InternalCommentThreadDiffAnchor anchor) {
            this.dstSpanEnd = anchor.dstSpanEnd;
            this.dstSpanStart = anchor.dstSpanStart;
            this.diffType = anchor.diffType;
            this.fileType = anchor.fileType;
            this.fromHash = anchor.fromHash;
            this.line = anchor.line;
            this.lineType = anchor.lineType;
            this.multilineStartLine = anchor.multilineStartLine;
            this.multilineStartLineType = anchor.multilineStartLineType;
            this.orphaned = anchor.orphaned;
            this.path = anchor.path;
            this.srcPath = anchor.srcPath;
            this.srcSpanEnd = anchor.srcSpanEnd;
            this.srcSpanStart = anchor.srcSpanStart;
            this.toHash = anchor.toHash;
        }

        @Nonnull
        public Builder apply(@Nonnull AddFileCommentRequest request) {
            this.srcPath = request.getSrcPath();
            return this;
        }

        @Nonnull
        public Builder apply(@Nonnull AddLineCommentRequest request) {
            this.srcPath = request.getSrcPath();
            this.line = request.getLine();
            this.lineType = request.getLineType();
            this.fileType = request.getFileType();
            return this;
        }

        @Nonnull
        Builder apply(@Nonnull AddMultilineCommentRequest request) {
            if (request.getDestinationSpan() != null) {
                this.dstSpanStart = request.getDestinationSpan().minimum();
                this.dstSpanEnd = request.getDestinationSpan().maximum();
            }
            this.fileType = request.getFileType();
            this.line = request.getLine();
            this.lineType = request.getLineType();
            this.multilineStartLine = request.getStartLine();
            this.multilineStartLineType = request.getStartLineType();
            this.srcPath = request.getSrcPath();
            if (request.getSourceSpan() != null) {
                this.srcSpanStart = request.getSourceSpan().minimum();
                this.srcSpanEnd = request.getSourceSpan().maximum();
            }
            return this;
        }

        @Nonnull
        public InternalCommentThreadDiffAnchor build() {
            boolean hasMultilineMarker;
            boolean hasSrcSpan = this.srcSpanStart != null && this.srcSpanEnd != null;
            boolean hasDstSpan = this.dstSpanStart != null && this.dstSpanEnd != null;
            boolean bl = hasMultilineMarker = this.multilineStartLine != null && this.multilineStartLineType != null;
            if (hasMultilineMarker && !hasSrcSpan && !hasDstSpan) {
                throw new IllegalArgumentException("If there are no source or target span specified, we should not have a multiline marker (line & line type)");
            }
            if (!hasMultilineMarker && (hasSrcSpan || hasDstSpan)) {
                throw new IllegalArgumentException("If no multiline marker (line & line type) are specified, we should not have a source nor a destination span");
            }
            if (hasMultilineMarker && Objects.equals(this.multilineStartLine, this.line) && Objects.equals(this.multilineStartLineType, this.lineType)) {
                throw new IllegalArgumentException("The multiline start marker must be different to the anchor line.");
            }
            if (hasSrcSpan && !hasDstSpan && Objects.equals(this.srcSpanStart, this.srcSpanEnd)) {
                throw new IllegalArgumentException("The start and the end of a source span should not be nonnull and equal when no destination spans are specified.");
            }
            if (hasDstSpan && !hasSrcSpan && Objects.equals(this.dstSpanStart, this.dstSpanEnd)) {
                throw new IllegalArgumentException("The start and the end of a destination span should not be nonnull and equal when no source spans are specified.");
            }
            if (hasMultilineMarker && !Objects.equals(this.multilineStartLine, this.srcSpanStart) && !Objects.equals(this.multilineStartLine, this.dstSpanStart)) {
                throw new IllegalArgumentException("If the multilineStartLine exists, it must equal to either the source or the destination start");
            }
            if (hasMultilineMarker && !Objects.equals(this.line, this.srcSpanEnd) && !Objects.equals(this.line, this.dstSpanEnd)) {
                throw new IllegalArgumentException("If there is a source or a destination span, one of their end must equal the comment line anchor");
            }
            return new InternalCommentThreadDiffAnchor(this);
        }

        @Nonnull
        public Builder dstSpan(int start, int end) {
            Preconditions.checkArgument((start > 0 ? 1 : 0) != 0, (Object)"The destination start span line number should be a positive integer.");
            Preconditions.checkArgument((end > 0 ? 1 : 0) != 0, (Object)"The destination end span line number should be a positive integer.");
            Preconditions.checkArgument((end >= start ? 1 : 0) != 0, (Object)"The destination end span line number must be greater than or equal to the destination start span line number.");
            this.dstSpanStart = start;
            this.dstSpanEnd = end;
            return this;
        }

        @Nonnull
        public Builder fromHash(@Nullable String value) {
            this.fromHash = value;
            return this;
        }

        @Nonnull
        public Builder line(int line, @Nonnull DiffSegmentType lineType, @Nonnull DiffFileType fileType) {
            this.line = line;
            this.lineType = Objects.requireNonNull(lineType, "lineType");
            this.fileType = Objects.requireNonNull(fileType, "fileType");
            return this;
        }

        @Nonnull
        public Builder multiline(int multiLineStart, @Nonnull DiffSegmentType multilineStartType) {
            Preconditions.checkArgument((multiLineStart > 0 ? 1 : 0) != 0, (Object)"The multiline start line number should be a positive integer.");
            this.multilineStartLine = multiLineStart;
            this.multilineStartLineType = Objects.requireNonNull(multilineStartType, "multilineStartLineType");
            return this;
        }

        @Nonnull
        public Builder orphaned(boolean value) {
            this.orphaned = value;
            return this;
        }

        @Nonnull
        public Builder srcPath(@Nullable String value) {
            this.srcPath = value;
            return this;
        }

        @Nonnull
        public Builder srcSpan(int start, int end) {
            Preconditions.checkArgument((start > 0 ? 1 : 0) != 0, (Object)"The source start span line number should be a positive integer.");
            Preconditions.checkArgument((end > 0 ? 1 : 0) != 0, (Object)"The source end span line number should be a positive integer.");
            Preconditions.checkArgument((end >= start ? 1 : 0) != 0, (Object)"The source end span line number must be greater than or equal to the source start span line number.");
            this.srcSpanStart = start;
            this.srcSpanEnd = end;
            return this;
        }

        @Nonnull
        public Builder toHash(@Nonnull String value) {
            Preconditions.checkArgument((!Objects.requireNonNull(value, "toHash").trim().isEmpty() ? 1 : 0) != 0, (Object)"The \"to\" hash is required.");
            this.toHash = value;
            return this;
        }
    }
}

