/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.comment.CommentableVisitor;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitDiscussionParticipant;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionParticipant;
import com.atlassian.stash.internal.participant.InternalParticipable;
import com.atlassian.stash.internal.participant.ParticipableVisitor;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Cacheable
@Entity
@Table(name="sta_cmt_discussion", indexes={@Index(name="idx_sta_cmt_disc_cmt", columnList="commit_id"), @Index(name="idx_sta_cmt_disc_repo", columnList="repository_id")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_cmt_disc_repo_cmt", columnNames={"repository_id", "commit_id"})})
@TableGenerator(allocationSize=20, pkColumnValue="sta_cmt_discussion", name="commitDiscussionIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalCommitDiscussion
implements CommitDiscussion,
Initializable,
InternalCommentable,
InternalParticipable<InternalCommitDiscussionParticipant>,
InternalWatchable {
    public static final String ID_GEN = "commitDiscussionIdGenerator";
    public static final String TABLE = "sta_cmt_discussion";
    @Column(name="commit_id", nullable=false, length=40)
    @RequiredString(minimumSize=40, size=40)
    private final String commitId;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="commitDiscussionIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="parent_id", nullable=false, length=40)
    @OptionalString(minimumSize=40, size=40)
    private final String parentId;
    @Column(name="parent_count", nullable=false)
    private final int parents;
    @OneToMany(mappedBy="discussion", targetEntity=InternalCommitDiscussionParticipant.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private final Set<CommitDiscussionParticipant> participants;
    @JoinColumn(name="repository_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_cmt_disc_repo"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalRepository repository;

    protected InternalCommitDiscussion() {
        this.parentId = null;
        this.commitId = null;
        this.id = 0L;
        this.parents = 0;
        this.participants = new HashSet<CommitDiscussionParticipant>();
    }

    private InternalCommitDiscussion(Builder builder) {
        this.commitId = builder.commitId;
        this.id = builder.id;
        this.parentId = builder.parentId;
        this.parents = builder.parents;
        this.participants = new HashSet<CommitDiscussionParticipant>(builder.participants);
        this.repository = builder.repository;
    }

    @Override
    public <T> T accept(@Nonnull CommentableVisitor<T> visitor) {
        return (T)visitor.visit((CommitDiscussion)this);
    }

    @Override
    public <T> T accept(@Nonnull ParticipableVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <T> T accept(@Nonnull WatchableVisitor<T> visitor) {
        return (T)visitor.visit((CommitDiscussion)this);
    }

    @Override
    public void addParticipant(@Nonnull InternalCommitDiscussionParticipant participant) {
        this.participants.add(participant);
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalCommitDiscussion) {
            InternalCommitDiscussion that = (InternalCommitDiscussion)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String getParentId() {
        return this.parentId;
    }

    @Nonnull
    public Set<CommitDiscussionParticipant> getParticipants() {
        return Collections.unmodifiableSet(this.participants);
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Override
    @Nonnull
    public InternalRepository getScopeRepository() {
        return this.getRepository();
    }

    public boolean isMerge() {
        return this.parents > 1;
    }

    @Override
    public void initialize() {
        this.repository = HibernateUtils.initialize(this.getRepository());
        Hibernate.initialize(this.getParticipants());
        for (CommitDiscussionParticipant participant : this.getParticipants()) {
            Hibernate.initialize((Object)participant);
            Hibernate.initialize((Object)participant.getUser());
        }
    }

    @Override
    public void removeParticipant(@Nonnull InternalCommitDiscussionParticipant participant) {
        this.participants.remove(participant);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("commitId", (Object)this.commitId).add("repository", (Object)this.repository).toString();
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final long id;
        private final Set<CommitDiscussionParticipant> participants;
        private final InternalRepository repository;
        private String parentId;
        private int parents;

        public Builder(@Nonnull InternalCommitDiscussion discussion) {
            Objects.requireNonNull(discussion, "discussion");
            this.commitId = Builder.checkNotBlank((String)discussion.getCommitId(), (String)"discussion.commitId");
            this.id = discussion.getId();
            this.participants = new HashSet<CommitDiscussionParticipant>(discussion.getParticipants());
            this.repository = Objects.requireNonNull(discussion.getRepository(), "discussion.repository");
        }

        public Builder(@Nonnull InternalRepository repository, @Nonnull String commitId) {
            this.commitId = Builder.checkNotBlank((String)commitId, (String)"commitId");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.id = 0L;
            this.participants = new HashSet<CommitDiscussionParticipant>();
        }

        @Nonnull
        public InternalCommitDiscussion build() {
            return new InternalCommitDiscussion(this);
        }

        @Nonnull
        public Builder parents(@Nullable Collection<? extends MinimalCommit> value) {
            if (value == null || value.isEmpty()) {
                this.parentId = null;
                this.parents = 0;
            } else {
                this.parentId = ((MinimalCommit)Iterables.getFirst(value, null)).getId();
                this.parents = value.size();
            }
            return this.self();
        }

        @Nonnull
        public Builder participant(@Nullable CommitDiscussionParticipant value) {
            return this.participants(value, new CommitDiscussionParticipant[0]);
        }

        @Nonnull
        public Builder participants(@Nullable Iterable<CommitDiscussionParticipant> values) {
            Builder.addIf(Objects::nonNull, this.participants, values);
            return this.self();
        }

        @Nonnull
        public Builder participants(@Nullable CommitDiscussionParticipant value, CommitDiscussionParticipant ... values) {
            Builder.addIf(Objects::nonNull, this.participants, (Object)value, (Object[])values);
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

