/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussionCommentActivity;
import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.repository.RepositoryActivityVisitor;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.commit.InternalCommitDiscussionActivity;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrimaryKeyJoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@DiscriminatorValue(value="5")
@Entity
@PrimaryKeyJoinColumn(name="activity_id", referencedColumnName="activity_id", foreignKey=@ForeignKey(name="fk_bb_cmt_disc_com_act_id"))
@Table(name="bb_cmt_disc_comment_activity", indexes={@Index(name="idx_bb_cmt_disc_com_act_com", columnList="comment_id")})
public class InternalCommitDiscussionCommentActivity
extends InternalCommitDiscussionActivity
implements CommitDiscussionCommentActivity {
    public static final String TABLE = "bb_cmt_disc_comment_activity";
    @JoinColumn(name="comment_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_cmt_disc_com_act_com"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalComment comment;
    @Column(name="comment_action", nullable=false, updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.comment.CommentAction")})
    private final CommentAction commentAction;
    @Transient
    private Diff diff;

    protected InternalCommitDiscussionCommentActivity() {
        this.comment = null;
        this.commentAction = null;
    }

    private InternalCommitDiscussionCommentActivity(Builder builder) {
        super(builder);
        this.comment = builder.comment;
        this.commentAction = builder.commentAction;
    }

    public <T> T accept(@Nonnull RepositoryActivityVisitor<T> visitor) {
        return (T)visitor.visit((CommitDiscussionCommentActivity)this);
    }

    @Nonnull
    public InternalComment getComment() {
        return this.comment;
    }

    @Nonnull
    public CommentAction getCommentAction() {
        return this.commentAction;
    }

    @Nonnull
    public Optional<Diff> getDiff() {
        return Optional.ofNullable(this.diff);
    }

    @Override
    public void initialize() {
        super.initialize();
        HibernateUtils.initialize(this.getComment());
    }

    public void setDiff(Diff value) {
        if (this.diff != null) {
            throw new IllegalStateException("You cannot set the diff after it's been initialized");
        }
        this.diff = value;
    }

    public static class Builder
    extends InternalCommitDiscussionActivity.AbstractCommitDiscussionActivityBuilder<Builder, InternalCommitDiscussionCommentActivity> {
        private InternalComment comment;
        private CommentAction commentAction;

        public Builder(@Nonnull InternalCommitDiscussion discussion) {
            super(discussion);
        }

        public Builder(@Nonnull InternalCommitDiscussionCommentActivity activity) {
            super(activity);
            this.comment = activity.getComment();
            this.commentAction = activity.getCommentAction();
        }

        @Override
        @Nonnull
        public InternalCommitDiscussionCommentActivity build() {
            return new InternalCommitDiscussionCommentActivity(this);
        }

        @Nonnull
        public Builder comment(@Nonnull InternalComment value) {
            this.comment = Objects.requireNonNull(value, "comment");
            return this.self();
        }

        @Nonnull
        public Builder commentAction(@Nonnull CommentAction value) {
            this.commentAction = Objects.requireNonNull(value, "commentAction");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

