/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit;

import com.atlassian.bitbucket.commit.CommitDiscussionParticipant;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.commit.InternalCommitDiscussion;
import com.atlassian.stash.internal.participant.InternalAbstractParticipant;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;

@Cacheable
@Entity
@Table(name="sta_cmt_disc_participant", indexes={@Index(name="idx_sta_cmt_disc_part_disc", columnList="discussion_id"), @Index(name="idx_sta_cmt_disc_part_user", columnList="user_id")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_cmt_disc_part_disc_user", columnNames={"discussion_id", "user_id"})})
@TableGenerator(allocationSize=5, pkColumnValue="sta_cmt_disc_participant", name="commitDiscussionParticipantIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Immutable
public class InternalCommitDiscussionParticipant
extends InternalAbstractParticipant<InternalCommitDiscussionParticipant>
implements CommitDiscussionParticipant {
    public static final String ID_GEN = "commitDiscussionParticipantIdGenerator";
    public static final String TABLE = "sta_cmt_disc_participant";
    @JoinColumn(name="discussion_id", nullable=false, foreignKey=@ForeignKey(name="fk_sta_cmt_disc_part_disc"), updatable=false)
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalCommitDiscussion discussion;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="commitDiscussionParticipantIdGenerator", strategy=GenerationType.TABLE)
    private final long id;

    protected InternalCommitDiscussionParticipant() {
        this.discussion = null;
        this.id = 0L;
    }

    private InternalCommitDiscussionParticipant(Builder builder) {
        super(builder);
        this.discussion = builder.discussion;
        this.id = builder.id;
    }

    @Nonnull
    public InternalCommitDiscussion getDiscussion() {
        return this.discussion;
    }

    @Nonnull
    public InternalCommitDiscussion getEntity() {
        return this.getDiscussion();
    }

    public long getId() {
        return this.id;
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getDiscussion());
        super.initialize();
    }

    public static class Builder
    extends InternalAbstractParticipant.AbstractParticipantBuilder<Builder, InternalCommitDiscussionParticipant> {
        private final InternalCommitDiscussion discussion;
        private final long id;

        public Builder(@Nonnull InternalCommitDiscussion discussion) {
            this.discussion = Objects.requireNonNull(discussion, "discussion");
            this.id = 0L;
        }

        public Builder(@Nonnull InternalCommitDiscussionParticipant participant) {
            super(participant);
            this.discussion = participant.getDiscussion();
            this.id = 0L;
        }

        @Nonnull
        public InternalCommitDiscussionParticipant build() {
            return new InternalCommitDiscussionParticipant(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

