/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ConflictChange;
import com.atlassian.bitbucket.content.Path;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class InternalChangeLocation {
    private final String path;
    private final String srcPath;

    protected InternalChangeLocation(String path, String srcPath) {
        this.path = Objects.requireNonNull(path, "path");
        this.srcPath = srcPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InternalChangeLocation) {
            InternalChangeLocation that = (InternalChangeLocation)o;
            return Objects.equals(this.getPath(), that.getPath()) && Objects.equals(this.getSrcPath(), that.getSrcPath());
        }
        return false;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public int hashCode() {
        return Objects.hash(this.getPath(), this.getSrcPath());
    }

    public String toString() {
        return "InternalChangeLocation{path='" + this.getPath() + "', srcPath='" + this.getSrcPath() + "'}";
    }

    public static class Builder {
        private String path;
        private String srcPath;

        public Builder() {
        }

        public Builder(@Nonnull Change change) {
            this(change.getPath(), change.getSrcPath());
        }

        public Builder(@Nonnull ConflictChange change) {
            this(change.getPath(), change.getSrcPath());
        }

        public Builder(@Nonnull InternalChangeLocation location) {
            this.path = location.getPath();
            this.srcPath = location.getSrcPath();
        }

        private Builder(Path path, Path srcPath) {
            this.path = Builder.unwrap(path);
            this.srcPath = Builder.unwrap(srcPath);
        }

        public InternalChangeLocation build() {
            Objects.requireNonNull(this.path, "A path is required");
            return new InternalChangeLocation(this.path, this.srcPath);
        }

        public Builder path(@Nonnull String value) {
            this.path = Objects.requireNonNull(value, "path");
            return this;
        }

        public Builder srcPath(String value) {
            this.srcPath = value;
            return this;
        }

        private static String unwrap(Path path) {
            return path == null ? null : path.toString();
        }
    }
}

