/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.darkfeature;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@Entity
@Table(name="bb_user_dark_feature", uniqueConstraints={@UniqueConstraint(name="uq_bb_user_dark_feat_user_feat", columnNames={"user_id", "feature_key"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalUserDarkFeature {
    public static final String TABLE = "bb_user_dark_feature";
    private static final int MAX_FEATURE_KEY_LENGTH = 255;
    private static final String ID_GEN = "userEnabledDarkFeatureIdGenerator";
    @Column(name="feature_key", nullable=false, updatable=false)
    @RequiredString(size=255)
    private final String featureKey;
    @Id
    @GeneratedValue(generator="userEnabledDarkFeatureIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="userEnabledDarkFeatureIdGenerator", table="id_sequence", pkColumnValue="bb_user_dark_feature", allocationSize=10)
    private final long id;
    @JoinColumn(name="user_id", nullable=false, updatable=false, foreignKey=@ForeignKey(name="fk_bb_user_dark_feature_user"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalApplicationUser user;
    @Column(name="is_enabled", nullable=false)
    private final boolean enabled;

    protected InternalUserDarkFeature() {
        this.enabled = true;
        this.featureKey = null;
        this.id = 0L;
        this.user = null;
    }

    private InternalUserDarkFeature(Builder builder) {
        this.enabled = builder.enabled;
        this.user = builder.user;
        this.id = builder.id;
        this.featureKey = builder.featureKey;
    }

    public long getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    public String getFeatureKey() {
        return this.featureKey;
    }

    @Nonnull
    public InternalApplicationUser getUser() {
        return this.user;
    }

    public static class Builder
    extends BuilderSupport {
        private final String featureKey;
        private final long id;
        private boolean enabled;
        private InternalApplicationUser user;

        public Builder(@Nonnull InternalUserDarkFeature darkFeature) {
            this.featureKey = Objects.requireNonNull(darkFeature, (String)"darkFeature").featureKey;
            this.user = darkFeature.user;
            this.id = darkFeature.id;
            this.enabled = darkFeature.enabled;
        }

        public Builder(@Nonnull InternalApplicationUser user, @Nonnull String featureKey) {
            this.featureKey = Objects.requireNonNull(featureKey, "featureKey");
            this.id = 0L;
            this.user = Objects.requireNonNull(user, "applicationUser");
            this.enabled = true;
        }

        @Nonnull
        public InternalUserDarkFeature build() {
            return new InternalUserDarkFeature(this);
        }

        @Nonnull
        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public Builder user(@Nonnull InternalApplicationUser value) {
            this.user = Objects.requireNonNull(value, "user");
            return this;
        }
    }
}

