/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.diagnostics;

import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.diagnostics.Alert;
import com.atlassian.diagnostics.AlertTrigger;
import com.atlassian.diagnostics.Issue;
import com.atlassian.diagnostics.Severity;
import com.atlassian.diagnostics.internal.dao.AlertEntity;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.time.Instant;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="bb_alert", indexes={@Index(name="bb_alert_issue", columnList="issue_id"), @Index(name="bb_alert_issue_component", columnList="issue_component_id"), @Index(name="bb_alert_node_lower", columnList="node_name_lower"), @Index(name="bb_alert_severity", columnList="issue_severity"), @Index(name="bb_alert_timestamp", columnList="timestamp"), @Index(name="bb_alert_plugin_lower", columnList="trigger_plugin_key_lower")})
@TableGenerator(allocationSize=25, pkColumnValue="bb_alert", name="alertIdGenerator", table="id_sequence")
@Immutable
public class InternalAlert
implements AlertEntity {
    public static final String ID_GEN = "alertIdGenerator";
    public static final String TABLE = "bb_alert";
    private static final Logger log = LoggerFactory.getLogger(InternalAlert.class);
    @Column(name="details_json")
    @Lob
    @OptionalString(size=0x7FFFFFFF)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String detailsJson;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="alertIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="issue_component_id", nullable=false)
    @RequiredString(size=255)
    private final String issueComponentId;
    @Column(name="issue_id", nullable=false)
    @RequiredString(size=255)
    private final String issueId;
    @Column(name="issue_severity", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.diagnostics.Severity")})
    private final Severity issueSeverity;
    @Column(name="node_name", nullable=false)
    @RequiredString(size=255)
    private final String nodeName;
    @Column(name="node_name_lower", nullable=false)
    @RequiredString(size=255)
    private final String nodeNameLower;
    @Column(name="timestamp", nullable=false)
    private final long timestamp;
    @Column(name="trigger_module")
    @OptionalString(size=1024)
    private final String triggerModule;
    @Column(name="trigger_plugin_key")
    @OptionalString(size=255)
    private final String triggerPluginKey;
    @Column(name="trigger_plugin_key_lower")
    @OptionalString(size=255)
    private final String triggerPluginKeyLower;
    @Column(name="trigger_plugin_version")
    @OptionalString(size=255)
    private final String triggerPluginVersion;

    protected InternalAlert() {
        this.detailsJson = null;
        this.id = 0L;
        this.issueComponentId = null;
        this.issueId = null;
        this.issueSeverity = null;
        this.nodeName = null;
        this.nodeNameLower = null;
        this.triggerModule = null;
        this.triggerPluginKey = null;
        this.triggerPluginKeyLower = null;
        this.triggerPluginVersion = null;
        this.timestamp = 0L;
    }

    public InternalAlert(@Nonnull Alert alert) {
        Issue issue = Objects.requireNonNull(alert, "alert").getIssue();
        AlertTrigger trigger = alert.getTrigger();
        this.detailsJson = alert.getDetails().map(details -> this.generateJson(details, issue)).orElse(null);
        this.id = alert.getId();
        this.issueComponentId = Objects.requireNonNull(StringUtils.trimToNull((String)Objects.requireNonNull(issue.getComponent(), "issueComponent").getId()), "issueComponentId");
        this.issueId = Objects.requireNonNull(StringUtils.trimToNull((String)issue.getId()), "issueId");
        this.issueSeverity = Objects.requireNonNull(issue.getSeverity(), "issueSeverity");
        this.nodeName = Objects.requireNonNull(StringUtils.trimToNull((String)alert.getNodeName()), "nodeName");
        this.nodeNameLower = StringUtils.lowerCase((String)this.nodeName, (Locale)Locale.ROOT);
        this.timestamp = Objects.requireNonNull(alert.getTimestamp(), "timestamp").toEpochMilli();
        this.triggerModule = trigger.getModule().map(StringUtils::trimToNull).orElse(null);
        this.triggerPluginKey = (String)MoreObjects.firstNonNull((Object)StringUtils.trimToNull((String)trigger.getPluginKey()), (Object)"not-detected");
        this.triggerPluginKeyLower = this.triggerPluginKey.toLowerCase(Locale.ROOT);
        this.triggerPluginVersion = trigger.getPluginVersion().map(StringUtils::trimToNull).orElse(null);
    }

    public String getDetailsJson() {
        return this.detailsJson;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getNodeName() {
        return this.nodeName;
    }

    @Nonnull
    public Instant getTimestamp() {
        return Instant.ofEpochMilli(this.timestamp);
    }

    @Nonnull
    public String getIssueComponentId() {
        return this.issueComponentId;
    }

    @Nonnull
    public String getIssueId() {
        return this.issueId;
    }

    @Nonnull
    public Severity getIssueSeverity() {
        return this.issueSeverity;
    }

    public String getTriggerModule() {
        return this.triggerModule;
    }

    @Nonnull
    public String getTriggerPluginKey() {
        return this.triggerPluginKey;
    }

    public String getTriggerPluginVersion() {
        return this.triggerPluginVersion;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.getId()).add("detailsJson", (Object)this.detailsJson).add("issueComponentId", (Object)this.issueComponentId).add("issueId", (Object)this.issueId).add("issueSeverity", (Object)this.issueSeverity).add("nodeName", (Object)this.nodeName).add("timestamp", this.timestamp).add("triggerModule", (Object)this.triggerModule).add("triggerPluginKey", (Object)this.triggerPluginKey).add("triggerPluginVersion", (Object)this.triggerPluginVersion).toString();
    }

    private String generateJson(Object details, Issue issue) {
        try {
            return Optional.ofNullable(details).map(d -> issue.getJsonMapper().toJson(d)).map(StringUtils::stripToNull).orElse(null);
        }
        catch (Exception e) {
            log.warn("Failed to store as JSON the details of an alert for issue {}", (Object)issue.getId());
            return null;
        }
    }
}

