/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.emoticon;

import com.atlassian.bitbucket.dmz.emoticon.DmzEmoticon;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cacheable
@Entity
@Table(name="bb_emoticon", indexes={@Index(name="idx_bb_emoticon_provider", columnList="provider")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalEmoticon
implements DmzEmoticon {
    public static final String TABLE = "bb_emoticon";
    @Column(length=32, nullable=false, unique=true)
    @Id
    @RequiredString(size=32)
    private final String id;
    @Column(length=20)
    @RequiredString(size=20)
    private final String provider;
    @Column
    @OptionalString
    private final String url;
    @Column(length=32, name="unicode")
    @OptionalString(size=32)
    private final String value;

    protected InternalEmoticon() {
        this.id = null;
        this.provider = null;
        this.url = null;
        this.value = null;
    }

    private InternalEmoticon(Builder builder) {
        this.id = builder.id;
        this.provider = builder.provider;
        this.url = builder.url;
        this.value = builder.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalEmoticon) {
            InternalEmoticon that = (InternalEmoticon)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getProvider() {
        return this.provider;
    }

    public String getUrl() {
        return this.url;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public String toString() {
        return "InternalEmoticon{id='" + this.id + "', provider='" + this.provider + "', url='" + this.url + "', value='" + this.value + "'}";
    }

    public static class Builder
    extends BuilderSupport {
        private final String id;
        private final String provider;
        private String url;
        private String value;

        public Builder(@Nonnull String id, @Nonnull String provider) {
            this.id = Objects.requireNonNull(id, "id");
            this.provider = Objects.requireNonNull(provider, "provider");
        }

        public Builder(@Nonnull InternalEmoticon emoticon) {
            this.id = Objects.requireNonNull(emoticon, "emoticon").getId();
            this.provider = emoticon.getProvider();
            this.url = emoticon.getUrl();
            this.value = emoticon.getValue();
        }

        @Nonnull
        public InternalEmoticon build() {
            return new InternalEmoticon(this);
        }

        @Nonnull
        public Builder url(@Nullable String value) {
            this.url = value;
            return this;
        }

        @Nonnull
        public Builder value(@Nullable String value) {
            this.value = value;
            return this;
        }
    }
}

