/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.group;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="sta_deleted_group", indexes={@Index(name="idx_sta_deleted_group_ts", columnList="deleted_timestamp")}, uniqueConstraints={@UniqueConstraint(name="uq_sta_deleted_group_name", columnNames={"name"})})
@TableGenerator(allocationSize=20, pkColumnValue="sta_deleted_group", name="deletedGroupIdGenerator", table="id_sequence")
public class InternalDeletedGroup {
    public static final String ID_GEN = "deletedGroupIdGenerator";
    public static final String TABLE = "sta_deleted_group";
    public static final int MAX_NAME_LENGTH = 255;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="deletedGroupIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="name", nullable=false, updatable=false)
    @RequiredString(size=255)
    private final String name;
    @Column(name="deleted_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date deletedDate;

    protected InternalDeletedGroup() {
        this.id = 0L;
        this.name = null;
        this.deletedDate = null;
    }

    protected InternalDeletedGroup(@Nonnull Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.deletedDate = new Date(builder.deletedDate.getTime());
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Date getDeletedDate() {
        return this.deletedDate;
    }

    public static class Builder
    extends BuilderSupport {
        private final long id;
        private String name;
        private Date deletedDate;

        public Builder() {
            this.id = 0L;
        }

        public Builder(@Nonnull InternalDeletedGroup deletedGroup) {
            Objects.requireNonNull(deletedGroup, "deletedGroup");
            this.id = deletedGroup.getId();
            this.name = deletedGroup.getName();
            this.deletedDate = deletedGroup.getDeletedDate();
        }

        @Nonnull
        public InternalDeletedGroup build() {
            Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"The group name is required");
            Preconditions.checkState((this.deletedDate != null ? 1 : 0) != 0, (Object)"The deleted date is required");
            return new InternalDeletedGroup(this);
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = IdentifierUtils.toLowerCase((String)Builder.checkNotBlank((String)value, (String)"name"));
            return this;
        }

        @Nonnull
        public Builder deletedDate(@Nonnull Date value) {
            this.deletedDate = Objects.requireNonNull(value, "deletedDate");
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

