/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.home;

import jakarta.annotation.Nonnull;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

public class HomeDirectoryDetails {
    private final Path home;
    private final Path sharedHome;

    public HomeDirectoryDetails(@Nonnull File home, @Nonnull File sharedHome) {
        this(Objects.requireNonNull(home, "home").toPath(), Objects.requireNonNull(sharedHome, "sharedHome").toPath());
    }

    public HomeDirectoryDetails(@Nonnull Path home, @Nonnull Path sharedHome) {
        this.home = Objects.requireNonNull(home, "home");
        this.sharedHome = Objects.requireNonNull(sharedHome, "sharedHome");
    }

    @Nonnull
    public Path getHome() {
        return this.home;
    }

    @Nonnull
    public String getHomeDir() {
        return this.home.toAbsolutePath().toString();
    }

    @Nonnull
    public Path getSharedHome() {
        return this.sharedHome;
    }

    @Nonnull
    public String getSharedHomeDir() {
        return this.sharedHome.toAbsolutePath().toString();
    }
}

