/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.hook.script.HookScript;
import com.atlassian.bitbucket.hook.script.HookScriptCreateRequest;
import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.hook.script.HookScriptUpdateRequest;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="bb_hook_script", indexes={@Index(name="idx_bb_hook_script_plugin", columnList="plugin_key"), @Index(name="idx_bb_hook_script_type", columnList="hook_type")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalHookScript
implements HookScript {
    public static final String ID_GEN = "hookScriptIdGenerator";
    public static final String TABLE = "bb_hook_script";
    @Column(name="created_timestamp", nullable=false, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date createdDate;
    @Column(name="hook_description")
    @OptionalString
    @OptimisticLock(excluded=true)
    private final String description;
    @Column(name="hook_hash", length=64, nullable=false)
    @RequiredString(minimumSize=40, size=64)
    private final String hash;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="hookScriptIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=10, pkColumnValue="bb_hook_script", name="hookScriptIdGenerator", table="id_sequence")
    private final long id;
    @Column(name="hook_name", nullable=false)
    @RequiredString
    @OptimisticLock(excluded=true)
    private final String name;
    @Column(name="plugin_key", nullable=false)
    @RequiredString
    @OptimisticLock(excluded=true)
    private final String pluginKey;
    @Column(name="hook_size", nullable=false)
    private final int size;
    @Column(name="hook_type", nullable=false, updatable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.hook.script.HookScriptType")})
    private final HookScriptType type;
    @Column(name="updated_timestamp", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @OptimisticLock(excluded=true)
    private final Date updatedDate;
    @Column(name="hook_version", nullable=false)
    @Version
    private final int version;

    protected InternalHookScript() {
        this.updatedDate = null;
        this.createdDate = null;
        this.pluginKey = null;
        this.name = null;
        this.hash = null;
        this.description = null;
        this.id = 0L;
        this.size = 0;
        this.type = null;
        this.version = 0;
    }

    private InternalHookScript(Builder builder) {
        this.description = builder.description;
        this.hash = builder.hash;
        this.id = builder.id;
        this.name = builder.name;
        this.pluginKey = builder.pluginKey;
        this.size = builder.size;
        this.type = builder.type;
        this.version = builder.version;
        Date now = new Date();
        this.createdDate = (Date)MoreObjects.firstNonNull((Object)builder.createdDate, (Object)now);
        this.updatedDate = (Date)MoreObjects.firstNonNull((Object)builder.updatedDate, (Object)now);
    }

    @Nonnull
    public Date getCreatedDate() {
        return new Date(this.createdDate.getTime());
    }

    @Nonnull
    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Nonnull
    public String getHash() {
        return this.hash;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getPluginKey() {
        return this.pluginKey;
    }

    public int getSize() {
        return this.size;
    }

    @Nonnull
    public HookScriptType getType() {
        return this.type;
    }

    @Nonnull
    public Date getUpdatedDate() {
        return new Date(this.updatedDate.getTime());
    }

    public int getVersion() {
        return this.version;
    }

    public static class Builder
    extends BuilderSupport {
        private final HookScriptType type;
        private Date createdDate;
        private String description;
        private String hash;
        private long id;
        private String name;
        private String pluginKey;
        private int size;
        private Date updatedDate;
        private int version;

        public Builder(@Nonnull String name, @Nonnull String pluginKey, @Nonnull HookScriptType type) {
            this.name = Builder.requireNonBlank((String)name, (String)"name");
            this.pluginKey = Builder.requireNonBlank((String)pluginKey, (String)"pluginKey");
            this.type = Objects.requireNonNull(type, "type");
            this.id = 0L;
        }

        public Builder(@Nonnull HookScriptCreateRequest request) {
            this(Objects.requireNonNull(request, "request").getName(), request.getPluginKey(), request.getType());
            this.description = request.getDescription().orElse(null);
        }

        public Builder(@Nonnull HookScriptUpdateRequest request) {
            this((InternalHookScript)Objects.requireNonNull(request, "request").getScript());
            this.description = request.getDescription().orElse(null);
            this.name = request.getName();
            this.pluginKey = request.getPluginKey();
        }

        public Builder(@Nonnull InternalHookScript script) {
            this.createdDate = script.getCreatedDate();
            this.description = script.getDescription().orElse(null);
            this.hash = script.getHash();
            this.id = script.getId();
            this.name = script.getName();
            this.pluginKey = script.getPluginKey();
            this.size = script.getSize();
            this.type = script.getType();
            this.updatedDate = script.getUpdatedDate();
            this.version = script.getVersion();
        }

        @Nonnull
        public InternalHookScript build() {
            if (this.hash == null) {
                throw new IllegalStateException("A hash of the script's contents is required");
            }
            return new InternalHookScript(this);
        }

        @Nonnull
        public Builder createdDate(@Nonnull Date value) {
            this.createdDate = Objects.requireNonNull(value, "createdDate");
            return this;
        }

        @Nonnull
        public Builder description(@Nullable String value) {
            this.description = StringUtils.trimToNull((String)value);
            return this;
        }

        @Nonnull
        public Builder hash(@Nonnull String value) {
            this.hash = Builder.requireNonBlank((String)value, (String)"hash");
            return this;
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Builder.requireNonBlank((String)value, (String)"name");
            return this;
        }

        @Nonnull
        public Builder pluginKey(@Nonnull String value) {
            this.pluginKey = Builder.requireNonBlank((String)value, (String)"pluginKey");
            return this;
        }

        @Nonnull
        public Builder size(int value) {
            this.size = value;
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nonnull Date value) {
            this.updatedDate = Objects.requireNonNull(value, "updatedDate");
            return this;
        }

        @Nonnull
        public Builder version(int value) {
            this.version = value;
            return this;
        }
    }
}

