/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook.script;

import com.atlassian.bitbucket.hook.script.HookScriptConfig;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.hook.script.InternalHookScript;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.MetaValue;

@Cacheable
@Entity
@Table(name="bb_hook_script_config", indexes={@Index(name="idx_bb_hook_script_cfg_scope", columnList="scope_id, scope_type"), @Index(name="idx_bb_hook_script_cfg_script", columnList="script_id")}, uniqueConstraints={@UniqueConstraint(name="uq_bb_hook_script_config", columnNames={"script_id", "scope_id", "scope_type"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalHookScriptConfig
implements HookScriptConfig,
Initializable {
    public static final String ID_GEN = "hookScriptConfigIdGenerator";
    public static final String TABLE = "bb_hook_script_config";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="hookScriptConfigIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(allocationSize=20, pkColumnValue="bb_hook_script_config", name="hookScriptConfigIdGenerator", table="id_sequence")
    private final long id;
    @JoinColumn(name="scope_id", updatable=false)
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="scope_type"))
    @AnyMetaDef(idType="integer", metaType="integer", metaValues={@MetaValue(targetEntity=InternalNormalProject.class, value="1"), @MetaValue(targetEntity=InternalPersonalProject.class, value="2"), @MetaValue(targetEntity=InternalRepository.class, value="3")})
    private final Scopeable scope;
    @JoinColumn(name="script_id", nullable=false, updatable=false, foreignKey=@ForeignKey(name="fk_bb_hook_script_cfg_script"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalHookScript script;
    @CollectionTable(name="bb_hook_script_trigger", foreignKey=@ForeignKey(name="fk_bb_hook_script_trgr_config"), indexes={@Index(name="idx_bb_hook_script_trgr_config", columnList="config_id")}, joinColumns={@JoinColumn(name="config_id", nullable=false)})
    @Column(name="trigger_id", nullable=false)
    @ElementCollection
    @OrderBy
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private final Set<String> triggerIds;

    public InternalHookScriptConfig(@Nonnull InternalHookScript script, @Nonnull Scope scope, @Nonnull Set<String> triggerIds) {
        this(0L, script, scope, triggerIds);
    }

    protected InternalHookScriptConfig() {
        this.id = 0L;
        this.scope = null;
        this.script = null;
        this.triggerIds = new HashSet<String>();
    }

    private InternalHookScriptConfig(long id, InternalHookScript script, Scope scope, Set<String> triggerIds) {
        this.id = id;
        this.scope = Scopeable.fromScope(scope);
        this.script = Objects.requireNonNull(script, "script");
        this.triggerIds = new HashSet<String>((Collection)Objects.requireNonNull(triggerIds, "triggerIds"));
    }

    @Nonnull
    public InternalHookScriptConfig copy() {
        return new InternalHookScriptConfig(this.getId(), this.getScript(), this.getScope(), this.getTriggerIds());
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope == null ? Scopes.global() : this.scope.toScope();
    }

    @Nonnull
    public InternalHookScript getScript() {
        return this.script;
    }

    @Nonnull
    public Set<String> getTriggerIds() {
        return Collections.unmodifiableSet(this.triggerIds);
    }

    @Override
    public void initialize() {
        Hibernate.initialize((Object)this.getScript());
        Hibernate.initialize((Object)this.scope);
        Hibernate.initialize(this.triggerIds);
    }

    public void setTriggerIds(@Nonnull Set<String> triggerIds) {
        Objects.requireNonNull(triggerIds, "triggerIds");
        if (triggerIds.isEmpty()) {
            this.triggerIds.clear();
        } else {
            this.triggerIds.retainAll(triggerIds);
            this.triggerIds.addAll(triggerIds);
        }
    }
}

