/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.idx.IndexedCommit;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.idx.InternalCommitAttribute;
import com.atlassian.stash.internal.idx.InternalRepositoryMembership;
import jakarta.annotation.Nonnull;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.Immutable;

@Entity
@Table(name="changeset")
@Immutable
public class InternalIndexedCommit
implements IndexedCommit,
Initializable {
    @Column(name="id")
    @Id
    @RequiredString(size=40)
    private final String id;
    @Column(name="author_timestamp")
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date authorTimestamp;
    @OneToMany(mappedBy="commit", cascade={CascadeType.REMOVE})
    @OrderBy(value="repository.id")
    private final Set<InternalRepositoryMembership> repositoryMemberships;
    @CollectionTable(name="cs_attribute", joinColumns={@JoinColumn(name="cs_id")})
    @ElementCollection
    private final Set<InternalCommitAttribute> attributes;

    protected InternalIndexedCommit() {
        this.id = null;
        this.authorTimestamp = null;
        this.attributes = new HashSet<InternalCommitAttribute>();
        this.repositoryMemberships = new HashSet<InternalRepositoryMembership>();
    }

    public InternalIndexedCommit(String id, Date authorTimestamp) {
        this.id = id;
        this.authorTimestamp = authorTimestamp;
        this.attributes = new HashSet<InternalCommitAttribute>();
        this.repositoryMemberships = new HashSet<InternalRepositoryMembership>();
    }

    public boolean addAttribute(InternalCommitAttribute attribute) {
        return this.attributes.add(attribute);
    }

    public boolean addMembership(InternalRepositoryMembership membership) {
        return this.repositoryMemberships.add(membership);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalIndexedCommit) {
            InternalIndexedCommit that = (InternalIndexedCommit)o;
            return Objects.equals(this.getId(), that.getId());
        }
        return false;
    }

    public Set<InternalCommitAttribute> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    @Nonnull
    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public Set<Repository> getRepositories() {
        Set<InternalRepositoryMembership> repositoryMemberships = this.getRepositoryMemberships();
        if (repositoryMemberships == null) {
            return Collections.emptySet();
        }
        return (Set)repositoryMemberships.stream().map(InternalRepositoryMembership::getRepository).collect(MoreCollectors.toImmutableSet());
    }

    public Set<InternalRepositoryMembership> getRepositoryMemberships() {
        return this.repositoryMemberships;
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    @Override
    public void initialize() {
        this.repositoryMemberships.forEach(HibernateUtils::initialize);
    }

    public boolean removeAttribute(InternalCommitAttribute attribute) {
        return this.attributes.remove(attribute);
    }

    public String toString() {
        return this.id;
    }
}

