/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.integrity;

import jakarta.annotation.Nonnull;
import java.util.Objects;

public enum IntegrityEventKey {
    ACKNOWLEDGED("acknowledged"),
    COMPLETED("completed"),
    INCONSISTENCY("inconsistency"),
    STARTED("started");

    private final String id;

    private IntegrityEventKey(String id) {
        this.id = id;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public static IntegrityEventKey fromId(@Nonnull String id) {
        Objects.requireNonNull(id, "id");
        for (IntegrityEventKey eventKey : IntegrityEventKey.values()) {
            if (!eventKey.getId().equalsIgnoreCase(id)) continue;
            return eventKey;
        }
        throw new IllegalArgumentException("No event key with the specified id exists");
    }
}

