/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.job;

import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.job.JobState;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Progress;
import com.atlassian.bitbucket.util.ProgressImpl;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Version;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_job", indexes={@Index(name="idx_bb_job_type", columnList="type"), @Index(name="idx_bb_job_state_type", columnList="state, type")})
@TableGenerator(allocationSize=20, pkColumnValue="bb_job", name="jobIdGenerator", table="id_sequence")
public class InternalJob
implements Job,
Initializable {
    public static final String ID_GEN = "jobIdGenerator";
    static final String TABLE = "bb_job";
    @Column(name="end_timestamp")
    private Instant endDate;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="jobIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @JoinColumn(name="initiator_id", foreignKey=@ForeignKey(name="fk_bb_job_initiator"), updatable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private InternalApplicationUser initiator;
    @Column(name="node_id", nullable=false)
    @RequiredString(size=64)
    private String nodeId;
    @Column(name="progress_message")
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    @OptionalString(size=1024)
    private String progressMessage;
    @Column(name="progress_percentage", nullable=false)
    private int progressPercentage;
    @Column(name="start_timestamp", nullable=false, updatable=false)
    private Instant startDate;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.job.JobState")})
    private JobState state;
    @Column(name="type", nullable=false, updatable=false)
    @RequiredString(size=256)
    private String type;
    @Column(name="updated_timestamp", nullable=false)
    private Instant updatedDate;
    @Column(name="entity_version", nullable=false)
    @Version
    private final int version;

    protected InternalJob() {
        this.id = 0L;
        this.version = 0;
    }

    private InternalJob(@Nonnull Builder builder) {
        Objects.requireNonNull(builder);
        Instant now = Instant.now();
        this.endDate = Optional.ofNullable(builder.endDate).orElse(null);
        this.id = builder.id;
        this.initiator = builder.initiator;
        this.nodeId = Objects.requireNonNull(builder.nodeId, "nodeId");
        this.progressMessage = builder.progressMessage;
        this.progressPercentage = Math.min(builder.state.isTerminated() ? 100 : 99, builder.progressPercentage);
        this.startDate = Optional.ofNullable(builder.startDate).orElse(now);
        this.state = builder.state;
        this.type = Objects.requireNonNull(builder.type, "type");
        this.updatedDate = Optional.ofNullable(builder.updatedDate).orElse(now);
        this.version = builder.version;
    }

    @Nonnull
    public Optional<Instant> getEndDate() {
        return Optional.ofNullable(this.endDate);
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public Optional<ApplicationUser> getInitiator() {
        return Optional.ofNullable(this.initiator);
    }

    @Nonnull
    public String getNodeId() {
        return this.nodeId;
    }

    @Nonnull
    public Progress getProgress() {
        return new ProgressImpl(this.progressMessage == null ? "" : this.progressMessage, this.progressPercentage);
    }

    @Nonnull
    public Instant getStartDate() {
        return this.startDate;
    }

    @Nonnull
    public JobState getState() {
        return this.state;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nonnull
    public Instant getUpdatedDate() {
        return this.updatedDate;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public void initialize() {
        this.initiator = HibernateUtils.initialize(this.getInitiator().map(InternalApplicationUser.class::cast).orElse(null));
    }

    public static class Builder {
        private Instant endDate;
        private long id;
        private InternalApplicationUser initiator;
        private String nodeId;
        private String progressMessage;
        private int progressPercentage;
        private Instant startDate;
        private JobState state;
        private String type;
        private Instant updatedDate;
        private int version;

        public Builder() {
            this.id = 0L;
            this.state = JobState.INITIALISING;
        }

        public Builder(@Nonnull InternalJob job) {
            Objects.requireNonNull(job, "job");
            this.endDate(job.getEndDate().orElse(null));
            this.id = job.getId();
            this.initiator(job.getInitiator().map(InternalApplicationUser.class::cast).orElse(null));
            this.nodeId(job.getNodeId());
            Progress progress = job.getProgress();
            this.progressMessage(progress.getMessage());
            this.progressPercentage(progress.getPercentage());
            this.startDate = job.getStartDate();
            this.state(job.getState());
            this.type(job.getType());
            this.updatedDate = job.getUpdatedDate();
            this.version = job.getVersion();
        }

        @Nonnull
        public InternalJob build() {
            return new InternalJob(this.self());
        }

        @Nonnull
        public Builder endDate(Instant value) {
            this.endDate = value;
            this.refreshUpdateDate();
            return this.self();
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            this.refreshUpdateDate();
            return this.self();
        }

        @Nonnull
        public Builder initiator(InternalApplicationUser value) {
            this.initiator = value;
            this.refreshUpdateDate();
            return this.self();
        }

        @Nonnull
        public Builder nodeId(@Nonnull String value) {
            this.nodeId = StringUtils.abbreviate((String)Objects.requireNonNull(StringUtils.trimToNull((String)value), "nodeId"), (int)64);
            this.refreshUpdateDate();
            return this.self();
        }

        @Nonnull
        public Builder progressMessage(String value) {
            this.progressMessage = StringUtils.abbreviate((String)StringUtils.trimToNull((String)value), (int)1024);
            this.refreshUpdateDate();
            return this.self();
        }

        @Nonnull
        public Builder progressPercentage(int value) {
            this.progressPercentage = Math.max(0, Math.min(value, 100));
            this.refreshUpdateDate();
            return this.self();
        }

        @Nonnull
        public Builder state(@Nonnull JobState value) {
            this.state = Objects.requireNonNull(value, "state");
            this.refreshUpdateDate();
            return this.self();
        }

        @Nonnull
        public Builder type(@Nonnull String value) {
            this.type = StringUtils.abbreviate((String)Objects.requireNonNull(StringUtils.trimToNull((String)value), "type"), (int)256);
            this.refreshUpdateDate();
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }

        private void refreshUpdateDate() {
            this.updatedDate = null;
        }
    }
}

