/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.job;

import com.atlassian.bitbucket.job.JobMessage;
import com.atlassian.bitbucket.job.JobMessageSeverity;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.job.InternalJob;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_job_message", indexes={@Index(name="idx_bb_job_msg_job_severity", columnList="job_id, severity")})
@TableGenerator(allocationSize=20, pkColumnValue="bb_job_message", name="jobMessageIdGenerator", table="id_sequence")
@Immutable
public class InternalJobMessage
implements JobMessage,
Initializable {
    public static final String ID_GEN = "jobMessageIdGenerator";
    static final String TABLE = "bb_job_message";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="jobMessageIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @JoinColumn(name="job_id", nullable=false, foreignKey=@ForeignKey(name="fk_bb_job_msg_job"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private InternalJob job;
    @Column(name="created_timestamp", nullable=false)
    private Instant createdDate;
    @Column(name="severity", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.job.JobMessageSeverity")})
    private JobMessageSeverity severity;
    @Column(name="subject")
    @OptionalString(size=1024)
    private String subject;
    @Column(name="text", nullable=false)
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    @RequiredString(size=1024)
    private String text;

    protected InternalJobMessage() {
        this.id = 0L;
    }

    private InternalJobMessage(Builder builder) {
        this.createdDate = Instant.now();
        this.job = Objects.requireNonNull(builder.job, "job");
        this.id = builder.id;
        this.severity = builder.severity;
        this.subject = builder.subject;
        this.text = Objects.requireNonNull(builder.text, "text");
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public InternalJob getJob() {
        return this.job;
    }

    @Nonnull
    public Optional<String> getSubject() {
        return Optional.ofNullable(this.subject);
    }

    @Nonnull
    public Instant getCreatedDate() {
        return this.createdDate;
    }

    @Nonnull
    public JobMessageSeverity getSeverity() {
        return this.severity;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    @Override
    public void initialize() {
        this.job = HibernateUtils.initialize(this.getJob());
    }

    public static class Builder {
        private long id;
        private InternalJob job;
        private JobMessageSeverity severity;
        private String subject;
        private String text;

        @VisibleForTesting
        protected Builder(@Nonnull InternalJobMessage message) {
            Objects.requireNonNull(message, "message");
            this.id = message.id;
            this.job = message.job;
            this.severity = message.severity;
            this.subject = message.subject;
            this.text = message.text;
        }

        public Builder() {
            this.id = 0L;
            this.severity = JobMessageSeverity.INFO;
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this.self();
        }

        @Nonnull
        public Builder job(@Nonnull InternalJob value) {
            this.job = Objects.requireNonNull(value, "job");
            return this.self();
        }

        @Nonnull
        public Builder severity(@Nonnull JobMessageSeverity value) {
            this.severity = Objects.requireNonNull(value, "severity");
            return this.self();
        }

        @Nonnull
        public Builder subject(String value) {
            this.subject = StringUtils.abbreviate((String)StringUtils.trimToNull((String)value), (int)1024);
            return this.self();
        }

        @Nonnull
        public Builder text(@Nonnull String value) {
            this.text = StringUtils.abbreviate((String)Objects.requireNonNull(StringUtils.trimToNull((String)value), "text"), (int)1024);
            return this.self();
        }

        @Nonnull
        public InternalJobMessage build() {
            return new InternalJobMessage(this);
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

