/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jpa;

import jakarta.persistence.AttributeConverter;
import java.time.DateTimeException;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoneIdConverter
implements AttributeConverter<ZoneId, String> {
    private static final Logger log = LoggerFactory.getLogger(ZoneIdConverter.class);

    public String convertToDatabaseColumn(ZoneId attribute) {
        return attribute == null ? null : attribute.getId();
    }

    public ZoneId convertToEntityAttribute(String dbData) {
        if (dbData == null) {
            return null;
        }
        try {
            return ZoneId.of(dbData);
        }
        catch (DateTimeException e) {
            log.debug("Unable to convert '{}' into a valid timezone. Defaulting to null.", (Object)dbData);
            return null;
        }
    }
}

