/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.merge;

import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.merge.MergeConfigType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.MappedSuperclass;
import java.util.Objects;
import java.util.Set;

@MappedSuperclass
public abstract class InternalAbstractMergeConfig {
    @Column(name="commit_summaries", nullable=false)
    private int commitSummaries;
    @Column(name="default_strategy_id", nullable=false)
    @RequiredString
    private String defaultStrategyId;

    protected InternalAbstractMergeConfig() {
        this.commitSummaries = 20;
        this.defaultStrategyId = null;
    }

    protected InternalAbstractMergeConfig(int commitSummaries, @Nonnull String defaultStrategyId) {
        this.commitSummaries = Math.max(commitSummaries, 0);
        this.defaultStrategyId = Objects.requireNonNull(defaultStrategyId, "defaultStrategyId");
    }

    public int getCommitSummaries() {
        return this.commitSummaries;
    }

    @Nonnull
    public String getDefaultStrategyId() {
        return this.defaultStrategyId;
    }

    @Nullable
    public abstract PullRequestCommitMessageTemplate getCommitMessageTemplate();

    public void setCommitSummaries(int commitSummaries) {
        this.commitSummaries = Math.max(commitSummaries, 0);
    }

    public void setDefaultStrategyId(@Nonnull String defaultStrategyId) {
        this.defaultStrategyId = Objects.requireNonNull(defaultStrategyId, "defaultStrategyId");
    }

    @Nonnull
    public abstract Set<String> getStrategyIds();

    @Nonnull
    public abstract MergeConfigType getType();
}

