/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.merge;

import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.stash.internal.merge.InternalAbstractMergeConfig;
import com.atlassian.stash.internal.merge.MergeConfigType;
import com.atlassian.stash.internal.pull.SimplePullRequestCommitMessageTemplate;
import com.atlassian.stash.internal.repository.InternalRepository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="bb_repo_merge_config", uniqueConstraints={@UniqueConstraint(name="uq_bb_repo_merge_config", columnNames={"repository_id"})})
@TableGenerator(allocationSize=10, pkColumnValue="bb_repo_merge_config", name="repositoryMergeConfigIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@NaturalIdCache
public class InternalRepositoryMergeConfig
extends InternalAbstractMergeConfig {
    public static final String ID_GEN = "repositoryMergeConfigIdGenerator";
    public static final String TABLE = "bb_repo_merge_config";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="repositoryMergeConfigIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="repository_id", unique=true, updatable=false)
    @NaturalId
    private final int repositoryId;
    @CollectionTable(name="bb_repo_merge_strategy", foreignKey=@ForeignKey(name="fk_bb_repo_merge_strategy"), joinColumns={@JoinColumn(name="config_id")})
    @Column(name="strategy_id", nullable=false)
    @ElementCollection
    @OrderBy
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private final Set<String> strategyIds;
    @Column(name="commit_message_template_body")
    @Lob
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    @OptionalString(size=5000)
    @Nullable
    private String commitMessageTemplateBody;
    @Column(name="commit_message_template_title")
    @OptionalString(size=255)
    @Nullable
    private String commitMessageTemplateTitle;

    public InternalRepositoryMergeConfig(@Nonnull InternalRepository repository, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> strategyIds, @Nullable PullRequestCommitMessageTemplate commitMessageTemplate) {
        super(commitSummaries, defaultStrategyId);
        this.repositoryId = Objects.requireNonNull(repository, "repository").getId();
        this.strategyIds = new HashSet<String>((Collection)Objects.requireNonNull(strategyIds, "strategyIds"));
        if (commitMessageTemplate != null) {
            this.commitMessageTemplateTitle = StringUtils.trimToNull((String)commitMessageTemplate.getTitle());
            this.commitMessageTemplateBody = StringUtils.trimToNull((String)commitMessageTemplate.getBody());
        }
        this.id = 0L;
    }

    protected InternalRepositoryMergeConfig() {
        this.commitMessageTemplateBody = null;
        this.commitMessageTemplateTitle = null;
        this.id = 0L;
        this.repositoryId = 0;
        this.strategyIds = new HashSet<String>();
    }

    @Override
    @Nullable
    public PullRequestCommitMessageTemplate getCommitMessageTemplate() {
        if (this.commitMessageTemplateTitle == null) {
            return null;
        }
        return new SimplePullRequestCommitMessageTemplate.Builder(this.commitMessageTemplateTitle).body(StringUtils.trimToEmpty((String)this.commitMessageTemplateBody)).build();
    }

    public long getId() {
        return this.id;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    @Nonnull
    public Set<String> getStrategyIds() {
        return Collections.unmodifiableSet(this.strategyIds);
    }

    @Override
    @Nonnull
    public MergeConfigType getType() {
        return MergeConfigType.REPOSITORY;
    }

    public void setCommitMessageTemplate(@Nullable PullRequestCommitMessageTemplate commitMessageTemplate) {
        if (commitMessageTemplate != null) {
            this.commitMessageTemplateTitle = StringUtils.trimToNull((String)commitMessageTemplate.getTitle());
            this.commitMessageTemplateBody = StringUtils.trimToNull((String)commitMessageTemplate.getBody());
        } else {
            this.commitMessageTemplateTitle = null;
            this.commitMessageTemplateBody = null;
        }
    }

    public void setStrategyIds(@Nonnull Set<String> strategyIds) {
        Objects.requireNonNull(strategyIds, "strategyIds");
        this.strategyIds.retainAll(strategyIds);
        this.strategyIds.addAll(strategyIds);
    }
}

