/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.merge;

import com.atlassian.bitbucket.pull.PullRequestCommitMessageTemplate;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.merge.InternalAbstractMergeConfig;
import com.atlassian.stash.internal.merge.MergeConfigType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OrderBy;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NaturalIdCache;

@Cacheable
@Entity
@Table(name="bb_scm_merge_config", uniqueConstraints={@UniqueConstraint(name="uq_bb_scm_merge_config", columnNames={"scm_id"})})
@TableGenerator(allocationSize=1, pkColumnValue="bb_scm_merge_config", name="scmMergeConfigIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@NaturalIdCache
public class InternalScmMergeConfig
extends InternalAbstractMergeConfig {
    public static final String ID_GEN = "scmMergeConfigIdGenerator";
    public static final String TABLE = "bb_scm_merge_config";
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="scmMergeConfigIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="scm_id", nullable=false, updatable=false)
    @RequiredString
    @NaturalId
    private final String scmId;
    @CollectionTable(name="bb_scm_merge_strategy", foreignKey=@ForeignKey(name="fk_bb_scm_merge_strategy"), joinColumns={@JoinColumn(name="config_id")})
    @Column(name="strategy_id", nullable=false)
    @ElementCollection
    @OrderBy
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    private final Set<String> strategyIds;

    public InternalScmMergeConfig(@Nonnull String scmId, int commitSummaries, @Nonnull String defaultStrategyId, @Nonnull Set<String> strategyIds) {
        super(commitSummaries, defaultStrategyId);
        this.scmId = Objects.requireNonNull(scmId, "scmId");
        this.strategyIds = new HashSet<String>((Collection)Objects.requireNonNull(strategyIds, "strategyIds"));
        this.id = 0L;
    }

    protected InternalScmMergeConfig() {
        this.id = 0L;
        this.scmId = null;
        this.strategyIds = new HashSet<String>();
    }

    @Override
    @Nullable
    public PullRequestCommitMessageTemplate getCommitMessageTemplate() {
        return null;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public String getScmId() {
        return this.scmId;
    }

    @Override
    @Nonnull
    public Set<String> getStrategyIds() {
        return Collections.unmodifiableSet(this.strategyIds);
    }

    @Override
    @Nonnull
    public MergeConfigType getType() {
        return MergeConfigType.SCM;
    }

    public void setStrategyIds(@Nonnull Set<String> strategyIds) {
        Objects.requireNonNull(strategyIds, "strategyIds");
        this.strategyIds.retainAll(strategyIds);
        this.strategyIds.addAll(strategyIds);
    }
}

