/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mergequeue;

import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueEntry;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Objects;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_merge_queue", indexes={@Index(name="idx_bb_merge_queue_repo_pr_id", columnList="repository_id, pr_id", unique=true)})
public class InternalMergeQueueEntry
implements MergeQueueEntry {
    public static final String TABLE = "bb_merge_queue";
    @Column(name="auto_subject", nullable=false, updatable=false)
    private final boolean autoSubject;
    @Column(name="insertion_time", nullable=false, updatable=false)
    private final Instant insertionTime;
    @Column(name="merging_time")
    private final Instant mergingTime;
    @Column(name="message", updatable=false)
    @Lob
    @OptionalString(size=0x7FFFFFFF)
    @Type(type="com.atlassian.hibernate.extras.type.ClobType")
    private final String message;
    @Column(name="ordinal_id", nullable=false, updatable=true)
    private final long ordinalId;
    @Id
    @Column(name="pr_id", nullable=false, updatable=false)
    private final long pullRequestId;
    @Column(name="repository_id", nullable=false, updatable=false)
    private final int repositoryId;
    @Column(name="strategy_id", updatable=false)
    @OptionalString
    private final String strategyId;
    @Column(name="user_id", nullable=false, updatable=false)
    private final int userId;

    protected InternalMergeQueueEntry() {
        this.autoSubject = false;
        this.insertionTime = null;
        this.mergingTime = null;
        this.message = null;
        this.ordinalId = 0L;
        this.pullRequestId = 0L;
        this.repositoryId = 0;
        this.strategyId = null;
        this.userId = 0;
    }

    private InternalMergeQueueEntry(Builder builder) {
        this.autoSubject = builder.autoSubject;
        long millis = System.currentTimeMillis();
        this.insertionTime = Instant.ofEpochMilli(millis);
        this.ordinalId = millis;
        this.message = builder.message;
        this.pullRequestId = builder.pullRequestId;
        this.repositoryId = builder.repositoryId;
        this.strategyId = builder.strategyId;
        this.mergingTime = builder.mergingTime;
        this.userId = builder.userId;
    }

    public Instant getMergingTime() {
        return this.mergingTime;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    @Nullable
    public String getStrategyId() {
        return this.strategyId;
    }

    public int getUserId() {
        return this.userId;
    }

    @Nonnull
    public Instant insertionTime() {
        return this.insertionTime;
    }

    public boolean isAutoSubject() {
        return this.autoSubject;
    }

    public long ordinalId() {
        return this.ordinalId;
    }

    public static class Builder {
        private final long pullRequestId;
        private final int repositoryId;
        private final int userId;
        private boolean autoSubject;
        private Instant mergingTime;
        private String message;
        private String strategyId;

        public Builder(@Nonnull PullRequest pullRequest, @Nonnull ApplicationUser user) {
            Objects.requireNonNull(pullRequest, "pullRequest");
            this.pullRequestId = pullRequest.getId();
            this.repositoryId = pullRequest.getToRef().getRepository().getId();
            this.userId = Objects.requireNonNull(user, "user").getId();
        }

        public Builder(@Nonnull MergeQueueEntry mergeQueueEntry) {
            Objects.requireNonNull(mergeQueueEntry);
            this.pullRequestId = mergeQueueEntry.getPullRequestId();
            this.repositoryId = mergeQueueEntry.getRepositoryId();
            this.userId = mergeQueueEntry.getUserId();
            this.autoSubject = mergeQueueEntry.isAutoSubject();
            this.message = mergeQueueEntry.getMessage();
            this.strategyId = mergeQueueEntry.getStrategyId();
            this.mergingTime = mergeQueueEntry.getMergingTime();
        }

        public Builder autoSubject(boolean value) {
            this.autoSubject = value;
            return this;
        }

        @Nonnull
        public InternalMergeQueueEntry build() {
            return new InternalMergeQueueEntry(this);
        }

        @Nonnull
        public Builder mergingTime(@Nullable Instant value) {
            this.mergingTime = value;
            return this;
        }

        public Builder message(@Nullable String value) {
            this.message = value;
            return this;
        }

        @Nonnull
        public Builder strategyId(@Nullable String value) {
            this.strategyId = value;
            return this;
        }
    }
}

