/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mergequeue;

import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettings;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.project.InternalNormalProject;
import com.atlassian.stash.internal.project.InternalPersonalProject;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scope.Scopeable;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.MetaValue;

@Cacheable
@Entity
@Table(name="bb_merge_queue_settings", uniqueConstraints={@UniqueConstraint(name="uq_bb_merge_queue_settings_scp", columnNames={"scope_type", "scope_id"})})
@TableGenerator(allocationSize=20, pkColumnValue="bb_merge_queue_settings", name="mergeQueueSettingsIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalMergeQueueSettings
implements MergeQueueSettings,
Initializable {
    public static final String ID_GEN = "mergeQueueSettingsIdGenerator";
    public static final String TABLE = "bb_merge_queue_settings";
    @Column(name="enabled", nullable=false)
    private final boolean enabled;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="mergeQueueSettingsIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="merge_timeout", nullable=false)
    private final Duration mergeTimeout;
    @JoinColumn(name="scope_id", nullable=false, updatable=false)
    @Any(fetch=FetchType.LAZY, metaColumn=@Column(name="scope_type", nullable=false, updatable=false))
    @AnyMetaDef(idType="integer", metaType="integer", metaValues={@MetaValue(targetEntity=InternalNormalProject.class, value="1"), @MetaValue(targetEntity=InternalPersonalProject.class, value="2"), @MetaValue(targetEntity=InternalRepository.class, value="3")})
    private final Scopeable scope;

    protected InternalMergeQueueSettings() {
        this.enabled = false;
        this.id = 0L;
        this.mergeTimeout = null;
        this.scope = null;
    }

    private InternalMergeQueueSettings(Builder builder) {
        this.enabled = builder.enabled;
        this.id = builder.id;
        this.scope = builder.scope;
        this.mergeTimeout = builder.mergeTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalMergeQueueSettings that = (InternalMergeQueueSettings)o;
        return this.enabled == that.enabled && this.id == that.id && Objects.equals(this.mergeTimeout, that.mergeTimeout) && Objects.equals(this.scope, that.scope);
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public Optional<Duration> getMergeTimeout() {
        return Duration.ZERO.equals(this.mergeTimeout) ? Optional.empty() : Optional.ofNullable(this.mergeTimeout);
    }

    @Nonnull
    public Scope getScope() {
        return this.scope.toScope();
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.id, this.scope, this.mergeTimeout);
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.scope);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabled", this.enabled).add("id", this.id).add("mergeTimeout", (Object)this.mergeTimeout).add("scope", (Object)this.scope).toString();
    }

    public static class Builder {
        private final long id;
        private final Scopeable scope;
        private boolean enabled;
        private Duration mergeTimeout;

        public Builder(@Nonnull Scope scope) {
            Objects.requireNonNull(scope, "scope");
            Preconditions.checkArgument((scope.getType() != ScopeType.GLOBAL ? 1 : 0) != 0, (Object)"Merge queue settings can not be configured for the global scope");
            this.scope = Scopeable.fromScope(scope);
            this.id = 0L;
            this.mergeTimeout = Duration.ZERO;
        }

        public Builder(@Nonnull InternalMergeQueueSettings settings) {
            Objects.requireNonNull(settings, "settings");
            Objects.requireNonNull(settings.scope, "scope");
            this.enabled = settings.enabled;
            this.id = settings.id;
            this.scope = settings.scope;
            this.mergeTimeout = settings.mergeTimeout;
        }

        public InternalMergeQueueSettings build() {
            return new InternalMergeQueueSettings(this);
        }

        @Nonnull
        public Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        @Nonnull
        public Builder mergeTimeout(@Nonnull Duration value) {
            Objects.requireNonNull(value, "mergeTimeout");
            Preconditions.checkArgument((!value.isNegative() ? 1 : 0) != 0, (Object)"mergeTimeout must not be negative");
            this.mergeTimeout = value;
            return this;
        }
    }
}

