/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshNodeRegistry;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="bb_mesh_node")
@TableGenerator(allocationSize=1, pkColumnValue="bb_mesh_node", name="meshNodeIdGenerator", table="id_sequence")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalMeshNode
implements MeshNode {
    public static final String ID_GEN = "meshNodeIdGenerator";
    public static final String TABLE = "bb_mesh_node";
    @Column(name="availability_zone")
    @OptionalString(size=255)
    private final String availabilityZone;
    @Column(name="id", nullable=false, unique=true)
    @Id
    @GeneratedValue(generator="meshNodeIdGenerator", strategy=GenerationType.TABLE)
    private final long id;
    @Column(name="name", nullable=false, unique=true)
    private final String name;
    @Column(name="rpc_url", nullable=false, unique=true)
    private final String rpcUrl;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.mesh.MeshNode$State")})
    private final MeshNode.State state;
    @Transient
    private volatile DmzMeshNodeRegistry nodeRegistry;

    protected InternalMeshNode() {
        this.id = 0L;
        this.availabilityZone = null;
        this.name = null;
        this.rpcUrl = null;
        this.state = null;
    }

    private InternalMeshNode(Builder builder) {
        this.id = builder.id;
        this.availabilityZone = builder.availabilityZone;
        this.name = Objects.requireNonNull(builder.name, "name");
        this.rpcUrl = Objects.requireNonNull(builder.rpcUrl, "rpcUrl");
        this.state = Objects.requireNonNull(builder.state, "state");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalMeshNode) {
            InternalMeshNode that = (InternalMeshNode)o;
            return this.getId() == that.getId();
        }
        return false;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public MeshNode.State getInternalState() {
        return this.state;
    }

    public Date getLastSeenDate() {
        return this.nodeRegistry == null ? null : this.nodeRegistry.getLastSeenDate((MeshNode)this);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getRpcUrl() {
        return this.rpcUrl;
    }

    @Nonnull
    public MeshNode.State getState() {
        return this.isOffline() ? MeshNode.State.OFFLINE : this.state;
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean isAvailable() {
        return this.state == MeshNode.State.AVAILABLE && !this.isOffline();
    }

    public boolean isOffline() {
        return this.nodeRegistry != null && !this.nodeRegistry.isAvailable((MeshNode)this);
    }

    public void setNodeRegistry(DmzMeshNodeRegistry nodeRegistry) {
        this.nodeRegistry = nodeRegistry;
    }

    public String toString() {
        return this.name + " (" + this.rpcUrl + ")";
    }

    public static class Builder {
        private final long id;
        private String availabilityZone;
        private String name;
        private String rpcUrl;
        private MeshNode.State state;

        public Builder() {
            this(0L);
        }

        public Builder(long id) {
            this.id = id;
            this.state = MeshNode.State.AVAILABLE;
        }

        public Builder(@Nonnull InternalMeshNode node) {
            this.id = node.getId();
            this.availabilityZone = node.getAvailabilityZone();
            this.name = node.getName();
            this.rpcUrl = node.getRpcUrl();
            this.state = node.getInternalState();
        }

        @Nonnull
        public Builder availabilityZone(@Nullable String value) {
            this.availabilityZone = value;
            return this;
        }

        @Nonnull
        public InternalMeshNode build() {
            return new InternalMeshNode(this);
        }

        @Nonnull
        public Builder name(@Nonnull String value) {
            this.name = Objects.requireNonNull(value, "name");
            return this;
        }

        @Nonnull
        public Builder rpcUrl(@Nonnull String value) {
            this.rpcUrl = Objects.requireNonNull(value, "rpcUrl");
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull MeshNode.State value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }
    }
}

