/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Objects;
import org.hibernate.annotations.Type;

@Entity
@IdClass(value=PK.class)
@Table(name="bb_mesh_node_key")
public class InternalMeshNodeKey {
    public static final String TABLE = "bb_mesh_node_key";
    @Column(name="der", length=1024, nullable=false, updatable=false)
    @Type(type="org.hibernate.type.BinaryType")
    private final byte[] der;
    @Column(name="expiration_timestamp")
    private final Instant expirationTimestamp;
    @Column(name="fingerprint", length=50, updatable=false)
    @Id
    @RequiredString(size=50)
    private final String fingerprint;
    @Id
    @JoinColumn(name="node_id", updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalMeshNode node;

    protected InternalMeshNodeKey() {
        this.der = null;
        this.expirationTimestamp = null;
        this.fingerprint = null;
        this.node = null;
    }

    private InternalMeshNodeKey(Builder builder) {
        this.der = Objects.requireNonNull(builder.der, "der");
        this.expirationTimestamp = builder.expirationTimestamp;
        this.fingerprint = builder.fingerprint;
        this.node = builder.node;
    }

    @Nonnull
    public byte[] getDer() {
        return this.der;
    }

    @Nullable
    public Instant getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    @Nonnull
    public String getFingerprint() {
        return this.fingerprint;
    }

    @Nonnull
    public InternalMeshNode getNode() {
        return this.node;
    }

    public static class Builder
    extends BuilderSupport {
        private final String fingerprint;
        private final InternalMeshNode node;
        private byte[] der;
        private Instant expirationTimestamp;

        public Builder(@Nonnull InternalMeshNode node, @Nonnull String fingerprint) {
            this.fingerprint = Builder.requireNonBlank((String)fingerprint, (String)"fingerprint");
            this.node = Objects.requireNonNull(node, "node");
        }

        public Builder(@Nonnull InternalMeshNodeKey key) {
            this.der = Objects.requireNonNull(key, "key").getDer();
            this.expirationTimestamp = key.getExpirationTimestamp();
            this.fingerprint = key.getFingerprint();
            this.node = key.getNode();
        }

        @Nonnull
        public InternalMeshNodeKey build() {
            return new InternalMeshNodeKey(this);
        }

        @Nonnull
        public Builder der(@Nonnull byte[] value) {
            this.der = Objects.requireNonNull(value, "der");
            return this;
        }

        @Nonnull
        public Builder expirationTimestamp(@Nullable Instant value) {
            this.expirationTimestamp = value;
            return this;
        }

        @Nonnull
        public Builder publicKey(@Nonnull PublicKey value) {
            this.der = Objects.requireNonNull(value, "publicKey").getEncoded();
            return this;
        }
    }

    public static class PK
    implements Serializable {
        private final String fingerprint;
        private final long node;

        public PK(String fingerprint, long node) {
            this.fingerprint = fingerprint;
            this.node = node;
        }

        private PK() {
            this(null, 0L);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof PK) {
                PK pk = (PK)o;
                return this.node == pk.node && this.fingerprint.equals(pk.fingerprint);
            }
            return false;
        }

        @Nonnull
        public String getFingerprint() {
            return this.fingerprint;
        }

        public long getNode() {
            return this.node;
        }

        public int hashCode() {
            return 31 * Long.hashCode(this.node) + this.fingerprint.hashCode();
        }
    }
}

