/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigration;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationJobState;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.time.Instant;
import java.util.Objects;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Cacheable
@Entity
@Table(name="bb_mesh_partition_migration", indexes={@Index(name="idx_part_state_target_node", columnList="partition_id, state, target_node_id"), @Index(name="idx_state_target_node", columnList="state, target_node_id"), @Index(name="idx_state", columnList="state"), @Index(name="idx_target_node_id", columnList="target_node_id")}, uniqueConstraints={@UniqueConstraint(name="uq_bb_mesh_partition_migration", columnNames={"unique_token"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class InternalMeshPartitionMigration
implements Comparable<InternalMeshPartitionMigration>,
Initializable,
MeshPartitionMigration {
    static final String TABLE = "bb_mesh_partition_migration";
    private static final String ID_GEN = "meshPartitionMigrationIdGenerator";
    @Column(name="created_timestamp", nullable=false)
    private final Instant createdDate;
    @Column(name="id", nullable=false)
    @Id
    @GeneratedValue(generator="meshPartitionMigrationIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="meshPartitionMigrationIdGenerator", table="id_sequence", pkColumnValue="bb_mesh_partition_migration", allocationSize=10)
    private final long id;
    @Column(name="partition_id", nullable=false)
    private final int partition;
    @JoinColumn(name="source_node_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalMeshNode sourceNode;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.dmz.mesh.MeshPartitionMigrationJobState")})
    private final MeshPartitionMigrationJobState state;
    @JoinColumn(name="target_node_id", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalMeshNode targetNode;
    @Column(name="updated_timestamp")
    private final Instant updatedDate;
    @Column(name="unique_token", unique=true)
    @OptionalString
    private final String uniqueToken;
    @Column(name="entity_version", nullable=false)
    @Version
    private final long version;

    protected InternalMeshPartitionMigration() {
        this.id = 0L;
        this.partition = 0;
        this.sourceNode = null;
        this.targetNode = null;
        this.state = null;
        this.version = 0L;
        this.createdDate = null;
        this.updatedDate = null;
        this.uniqueToken = null;
    }

    private InternalMeshPartitionMigration(Builder builder) {
        this.id = builder.id;
        this.partition = builder.partition;
        this.sourceNode = builder.sourceNode;
        this.targetNode = builder.targetNode;
        this.state = builder.state;
        this.version = builder.version;
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
        this.uniqueToken = builder.uniqueToken;
    }

    @Override
    public int compareTo(InternalMeshPartitionMigration other) {
        int result = Integer.compare(this.partition, other.partition);
        return result == 0 ? Long.compare(this.id, other.id) : result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalMeshPartitionMigration that = (InternalMeshPartitionMigration)o;
        return this.id == that.id && this.partition == that.partition && this.version == that.version && Objects.equals(this.sourceNode, that.sourceNode) && Objects.equals(this.targetNode, that.targetNode) && this.state == that.state && Objects.equals(this.createdDate, that.createdDate) && Objects.equals(this.updatedDate, that.updatedDate);
    }

    @Nonnull
    public Instant getCreatedDate() {
        return this.createdDate;
    }

    public long getId() {
        return this.id;
    }

    public int getPartition() {
        return this.partition;
    }

    @Nonnull
    public InternalMeshNode getSourceNode() {
        return this.sourceNode;
    }

    @Nonnull
    public MeshPartitionMigrationJobState getState() {
        return this.state;
    }

    @Nonnull
    public InternalMeshNode getTargetNode() {
        return this.targetNode;
    }

    @Nullable
    public Instant getUpdatedDate() {
        return this.updatedDate;
    }

    public long getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.partition, this.sourceNode, this.targetNode, this.state, this.createdDate, this.updatedDate, this.version);
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.getSourceNode());
        HibernateUtils.initialize(this.getTargetNode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("sourceNode", (Object)this.sourceNode).add("targetNode", (Object)this.targetNode).add("partition", this.partition).add("state", (Object)this.state).add("createdDate", (Object)this.createdDate).add("updatedDate", (Object)this.updatedDate).add("version", this.version).toString();
    }

    public static class Builder {
        private Instant createdDate;
        private long id;
        private int partition;
        private InternalMeshNode sourceNode;
        private MeshPartitionMigrationJobState state;
        private InternalMeshNode targetNode;
        private String uniqueToken;
        private Instant updatedDate;
        private long version;

        public Builder(int partition, @Nonnull InternalMeshNode sourceNode, @Nonnull InternalMeshNode targetNode) {
            Objects.requireNonNull(sourceNode, "sourceNode");
            Objects.requireNonNull(targetNode, "targetNode");
            this.version = 0L;
            this.id = 0L;
            this.partition = partition;
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
            this.state = MeshPartitionMigrationJobState.INITIALIZING;
            this.createdDate = Instant.now();
        }

        public Builder(@Nonnull InternalMeshPartitionMigration other) {
            Objects.requireNonNull(other, "other");
            this.id = other.id;
            this.partition = other.partition;
            this.sourceNode = other.sourceNode;
            this.targetNode = other.targetNode;
            this.state = other.state;
            this.createdDate = other.createdDate;
            this.updatedDate = other.updatedDate;
            this.uniqueToken = other.uniqueToken;
            this.version = other.version;
        }

        public InternalMeshPartitionMigration build() {
            return new InternalMeshPartitionMigration(this);
        }

        @Nonnull
        public Builder createdDate(@Nonnull Instant value) {
            Objects.requireNonNull(value, "value");
            this.createdDate = value;
            return this;
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder partition(int value) {
            this.partition = value;
            return this;
        }

        @Nonnull
        public Builder sourceNode(@Nonnull InternalMeshNode value) {
            Objects.requireNonNull(value, "value");
            this.sourceNode = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull MeshPartitionMigrationJobState value) {
            Objects.requireNonNull(value, "value");
            this.state = value;
            return this;
        }

        @Nonnull
        public Builder targetNode(@Nonnull InternalMeshNode value) {
            Objects.requireNonNull(value, "value");
            this.targetNode = value;
            return this;
        }

        @Nonnull
        public Builder updatedDate(@Nullable Instant value) {
            this.updatedDate = value;
            return this;
        }

        @Nonnull
        public Builder uniqueToken(@Nullable String value) {
            this.uniqueToken = value;
            return this;
        }

        @Nonnull
        public Builder version(long value) {
            this.version = value;
            return this;
        }
    }
}

