/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.stash.internal.HibernateUtils;
import com.atlassian.stash.internal.Initializable;
import com.atlassian.stash.internal.mesh.InternalMeshNode;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="bb_mesh_partition_replica", uniqueConstraints={@UniqueConstraint(name="uq_mesh_part_repl_part_node", columnNames={"partition_id", "node_id"})})
public class InternalMeshPartitionReplica
implements Initializable,
Comparable<InternalMeshPartitionReplica>,
MeshPartitionReplica {
    public static final String TABLE = "bb_mesh_partition_replica";
    private static final String ID_GEN = "meshPartitionReplicaIdGenerator";
    @Column(name="id", nullable=false)
    @Id
    @GeneratedValue(generator="meshPartitionReplicaIdGenerator", strategy=GenerationType.TABLE)
    @TableGenerator(name="meshPartitionReplicaIdGenerator", table="id_sequence", pkColumnValue="bb_mesh_partition_replica", allocationSize=10)
    private final long id;
    @JoinColumn(name="node_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalMeshNode node;
    @Column(name="partition_id", nullable=false)
    private final int partition;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica$State")})
    private final MeshPartitionReplica.State state;

    protected InternalMeshPartitionReplica() {
        this.id = 0L;
        this.node = null;
        this.partition = 0;
        this.state = null;
    }

    private InternalMeshPartitionReplica(Builder builder) {
        this.id = builder.id;
        this.node = Objects.requireNonNull(builder.node, "node");
        this.partition = builder.partition;
        this.state = Objects.requireNonNull(builder.state, "state");
    }

    @Override
    public int compareTo(InternalMeshPartitionReplica other) {
        int result = Integer.compare(this.partition, other.partition);
        return result == 0 ? Long.compare(this.id, other.id) : result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalMeshPartitionReplica) {
            InternalMeshPartitionReplica that = (InternalMeshPartitionReplica)o;
            return this.getId() == that.getId();
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    @Nonnull
    public InternalMeshNode getNode() {
        return this.node;
    }

    public int getPartition() {
        return this.partition;
    }

    @Nonnull
    public MeshPartitionReplica.State getState() {
        return this.state;
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    @Override
    public void initialize() {
        HibernateUtils.initialize(this.node);
    }

    public boolean isAvailable() {
        return this.node != null && this.node.isAvailable() && this.state == MeshPartitionReplica.State.AVAILABLE;
    }

    public String toString() {
        return "InternalMeshPartitionReplica{id=" + this.id + ", node=" + String.valueOf(this.node == null ? "null" : Long.valueOf(this.node.getId())) + ", partition=" + this.partition + ", state=" + String.valueOf(this.state) + "}";
    }

    public static class Builder {
        private long id;
        private InternalMeshNode node;
        private int partition;
        private MeshPartitionReplica.State state;

        public Builder() {
            this.id = 0L;
            this.state = MeshPartitionReplica.State.AVAILABLE;
        }

        public Builder(@Nonnull InternalMeshPartitionReplica other) {
            this.id = Objects.requireNonNull(other, (String)"other").id;
            this.node = other.node;
            this.partition = other.partition;
            this.state = other.state;
        }

        @Nonnull
        public InternalMeshPartitionReplica build() {
            return new InternalMeshPartitionReplica(this);
        }

        @Nonnull
        public Builder id(long value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public Builder node(@Nonnull InternalMeshNode value) {
            this.node = Objects.requireNonNull(value, "node");
            return this;
        }

        @Nonnull
        public Builder partition(int value) {
            this.partition = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull MeshPartitionReplica.State value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }
    }
}

