/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mesh;

import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionReplica;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@IdClass(value=PK.class)
@Table(name="bb_mesh_repo_replica")
public class InternalMeshRepositoryReplica {
    public static final String TABLE = "bb_mesh_repo_replica";
    @Id
    @JoinColumn(name="replica_id", nullable=false, updatable=false, foreignKey=@ForeignKey(name="fk_bb_mesh_repo_replica_rpl"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalMeshPartitionReplica replica;
    @Column(name="entity_version", nullable=false)
    @Version
    private final long entityVersion;
    @Column(name="reported_at", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private final Date reportedAt;
    @Id
    @JoinColumn(name="repository_id", nullable=false, updatable=false, foreignKey=@ForeignKey(name="fk_bb_mesh_repo_replica_repo"))
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private final InternalRepository repository;
    @Column(name="state", nullable=false)
    @Type(type="com.atlassian.hibernate.extras.type.GenericEnumUserType", parameters={@Parameter(name="enumClass", value="com.atlassian.bitbucket.dmz.mesh.ReplicaState")})
    private final ReplicaState state;
    @Column(name="reported_version", nullable=false)
    private final long reportedVersion;

    protected InternalMeshRepositoryReplica() {
        this.replica = null;
        this.reportedAt = null;
        this.repository = null;
        this.state = null;
        this.reportedVersion = 0L;
        this.entityVersion = 0L;
    }

    private InternalMeshRepositoryReplica(Builder builder) {
        this.entityVersion = builder.entityVersion;
        this.replica = builder.replica;
        this.reportedAt = builder.reportedAt;
        this.repository = builder.repository;
        this.state = builder.state;
        this.reportedVersion = builder.reportedVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InternalMeshRepositoryReplica) {
            InternalMeshRepositoryReplica that = (InternalMeshRepositoryReplica)o;
            return Objects.equals(this.getReplica(), that.getReplica()) && Objects.equals(this.getRepository(), that.getRepository());
        }
        return false;
    }

    public long getEntityVersion() {
        return this.entityVersion;
    }

    @Nonnull
    public InternalMeshPartitionReplica getReplica() {
        return this.replica;
    }

    @Nonnull
    public Date getReportedAt() {
        return this.reportedAt;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    @Nonnull
    public ReplicaState getState() {
        return this.state;
    }

    public long getReportedVersion() {
        return this.reportedVersion;
    }

    public int hashCode() {
        return Objects.hash(this.getReplica(), this.getRepository());
    }

    @Nonnull
    public PK toPk() {
        return new PK(this.getReplica().getId(), this.getRepository().getId());
    }

    public static class Builder {
        private final InternalMeshPartitionReplica replica;
        private final InternalRepository repository;
        private long entityVersion;
        private Date reportedAt;
        private long reportedVersion;
        private ReplicaState state;

        public Builder(@Nonnull InternalMeshPartitionReplica replica, @Nonnull InternalRepository repository) {
            this.replica = Objects.requireNonNull(replica, "replica");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.entityVersion = 0L;
        }

        public Builder(@Nonnull InternalMeshRepositoryReplica repositoryReplica) {
            this.entityVersion = repositoryReplica.getEntityVersion();
            this.replica = Objects.requireNonNull(repositoryReplica, "repositoryReplica").getReplica();
            this.reportedAt = repositoryReplica.getReportedAt();
            this.repository = repositoryReplica.getRepository();
            this.state = repositoryReplica.getState();
            this.reportedVersion = repositoryReplica.getReportedVersion();
        }

        @Nonnull
        public InternalMeshRepositoryReplica build() {
            Preconditions.checkState((this.state != null ? 1 : 0) != 0, (Object)"A repository replica state must be specified");
            Preconditions.checkState((this.reportedVersion > 0L ? 1 : 0) != 0, (Object)"A positive version must be specified");
            if (this.reportedAt == null) {
                this.reportedAt = new Date();
            }
            return new InternalMeshRepositoryReplica(this);
        }

        @Nonnull
        public Builder entityVersion(long value) {
            this.entityVersion = value;
            return this;
        }

        @Nonnull
        public Builder reportedAt(@Nonnull Date value) {
            this.reportedAt = Objects.requireNonNull(value, "reportedAt");
            return this;
        }

        @Nonnull
        public Builder reportedVersion(long value) {
            this.reportedVersion = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull ReplicaState value) {
            this.state = Objects.requireNonNull(value, "state");
            return this;
        }
    }

    public static class PK
    implements Serializable {
        private final long replica;
        private final int repository;

        public PK() {
            this(0L, 0);
        }

        public PK(long replica, int repository) {
            this.replica = replica;
            this.repository = repository;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof PK) {
                PK pk = (PK)o;
                return this.replica == pk.replica && this.repository == pk.repository;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.replica, this.repository);
        }

        public String toString() {
            return "InternalMeshRepositoryReplica{" + this.replica + "/" + this.repository + "}";
        }
    }
}

